<?php

namespace App\Composer;

use Composer\Package\PackageInterface;
use Composer\Installer\LibraryInstaller;

class Installer extends LibraryInstaller
{
    /**
     * {@inheritDoc}
     */
    public function getInstallPath(PackageInterface $package)
    {
       
        $prefix = substr($package->getPrettyName(), 0, 23);
        $extra = $package->getExtra();
        if(isset($extra['module']))
            $module =  $extra['module'];
        else
            $module =  $package->getName();
        return 'app/code/'.$module;
    }

    /**
     * {@inheritDoc}
     */
    public function supports($packageType)
    {
        return 'ced-phalcon' === $packageType;
    }
}