<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

use App\Woocommercewebapi\Components\Core\Common As CoreCommon;

return [
    'restapi' => [
        'v1'=> [
            'GET' => [
                'routes' => [
                    /* Authentication Start */
                    CoreCommon::REST_URL_PREFIX . 'validate-shop'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'validate-shop',
                        'method' => 'validateShop',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'validate-shop',
                        'component'=> 'Authenticate',
                        'required' => ['shop_id']
                    ],
                    /* Authentication End */

                    /* Product Start */
                    CoreCommon::REST_URL_PREFIX . 'products'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'products',
                        'method' => 'getAllProducts',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'products',
                        'component'=> 'Product'
                    ],

                    CoreCommon::REST_URL_PREFIX . 'product/settings'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'product/settings',
                        'method' => 'getProductSettings',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'product/settings',
                        'component'=> 'Product'
                    ],

                    CoreCommon::REST_URL_PREFIX . 'general/settings'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'general/settings',
                        'method' => 'getGeneralSettings',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'general/settings',
                        'component'=> 'Product'
                    ],                    

                    CoreCommon::REST_URL_PREFIX . 'products/retrieve-a-product'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'products/retrieve-a-product',
                        'method' => 'getProductById',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'products/retrieve-a-product',
                        'component'=> 'Product',
                        'required' => ['product_id']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'products/variations'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'products/variations',
                        'method' => 'getProductVariations',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'products/variations',
                        'component'=> 'Product',
                        'required' => ['product_id']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'products/categories'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'products/categoriess',
                        'method' => 'getProductsCategories',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'products/categories',
                        'component'=> 'Product'
                    ],

                    // // shipping start.
                    CoreCommon::REST_URL_PREFIX . 'shipping/getnames' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'shipping/getnames',
                        'method' => 'getWoocommerceCarrier',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'shipping/getnames',
                        'component'=> 'Shipping'
                    ],

                    CoreCommon::REST_URL_PREFIX . 'products/attributes'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'products/attributes',
                        'method' => 'getProductsAttributes',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'products/attributes',
                        'component'=> 'Product'
                    ],

                    CoreCommon::REST_URL_PREFIX . 'meta-attributes'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'meta-attributes',
                        'method' => 'getMetaAttributes',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'meta-attributes',
                        'component'=> 'Product'
                    ],

                    /* Product End */

                    /* Data Start */

                    CoreCommon::REST_URL_PREFIX . 'data/currencies/current'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'data/currencies/current',
                        'method' => 'getCurrentCurrency',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'data/currencies/current',
                        'component'=> 'Data'
                    ],

                    /* Data End */

                    /* Webhooks Start */
                    CoreCommon::REST_URL_PREFIX . 'webhooks' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'webhooks',
                        'method' => 'getAllWebhooks',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'webhooks',
                        'component'=> 'Webhook'
                    ],

                    CoreCommon::REST_URL_PREFIX . 'webhooks/retrieve-a-webhook' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'webhooks/retrieve-a-webhook',
                        'method' => 'getWebhookByTopic',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'webhooks/retrieve-a-webhook',
                        'component'=> 'Webhook',
                        'required' => ['topic']
                    ],
                    /* Webhooks End */

                    /* Order Start */
                    CoreCommon::REST_URL_PREFIX . 'orders' => [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'orders',
                        'method'    => 'getAllOrders',
                        'resource'  => CoreCommon::REST_URL_PREFIX . 'orders',
                        'component' => 'Order'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'orders/retrieve-an-order' => [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'orders/retrieve-an-order',
                        'method'    => 'getOrderById',
                        'resource'  => CoreCommon::REST_URL_PREFIX . 'orders/retrieve-an-order',
                        'component' => 'Order',
                        'required'  => ['order_id']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'get_order_status' => [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'get_order_status',
                        'method'    => 'getOrderStatus',
                        'resource'  => CoreCommon::REST_URL_PREFIX . 'get_order_status',
                        'component' => 'Order'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'retrieve-customers' => [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'retrieve-customers',
                        'method'    => 'getCustomers',
                        'resource'  => CoreCommon::REST_URL_PREFIX . 'retrieve-customers',
                        'component' => 'Customer'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'customer/retrieve-an-customer' => [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'customer/retrieve-an-customer',
                        'method'    => 'getCustomerById',
                        'resource'  => CoreCommon::REST_URL_PREFIX . 'customer/retrieve-an-customer',
                        'component' => 'Customer',
                        'required'  => ['customer_id']
                    ],
                    CoreCommon::REST_URL_PREFIX . 'getAttributeValues' => [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'getAttributeValues',
                        'method'    => 'getAttributeValues',
                        'resource'  => CoreCommon::REST_URL_PREFIX . 'getAttributeValues',
                        'component' => 'Product'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'get_tax_class' => [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'get_tax_class',
                        'method'    => 'getTaxClasses',
                        'resource'  => CoreCommon::REST_URL_PREFIX . 'get_tax_class',
                        'component' => 'Order'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'get_order_statusses' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'get_order_statusses',
                        'method' => 'getOrderStatusses',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'get_order_statusses',
                        'component'=> 'Order'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'get_taxes' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'get_taxes',
                        'method' => 'getTaxes',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'get_taxes',
                        'component'=> 'Order'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'get_a_tax' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'get_a_tax',
                        'method' => 'getTaxesById',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'get_a_tax',
                        'component'=> 'Order',
                        'required'  => ['tax_id']
                    ],
                    /* Order End */
                ],
            ],
            'POST' => [
                'routes' => [
                    /* Authentication Start */
                    CoreCommon::REST_URL_PREFIX . 'authenticate'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'authenticate',
                        'method' => 'addDomainInformation',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'authenticate',
                        'component'=> 'Authenticate',
                        'required' => [
                            CoreCommon::WOOCOMMERCE_DOMAIN_FIELD_NAME,
                            CoreCommon::CONSUMER_KEY_FIELD_NAME,
                            CoreCommon::CONSUMER_SECRET_FIELD_NAME
                        ]
                    ],
                    CoreCommon::REST_URL_PREFIX . 'product/upsert'=> [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'product/upsert',
                        'method'    => 'upsertProducts',
                        'resource'  => CoreCommon::REST_URL_PREFIX . 'product/upsert',
                        'component' => 'Product',
                    ],
                    CoreCommon::REST_URL_PREFIX . 'product/upsertVariation'=> [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'product/upsertVariation',
                        'method'    => 'upsertVariation',
                        'resource'  => CoreCommon::REST_URL_PREFIX . 'product/upsertVariation',
                        'component' => 'Product',
                    ],
                    /* Authentication End */

                    /* Webhooks Start */
                    CoreCommon::REST_URL_PREFIX . 'webhooks' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'webhooks',
                        'method' => 'createWebhook',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'webhooks',
                        'component'=> 'Webhook',
                        'required' => ['name', 'topic', 'delivery_url']
                    ],
                    CoreCommon::REST_URL_PREFIX . 'webhooks/batch' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'webhooks/batch',
                        'method' => 'batchUpdateWebhooks',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'webhooks/batch',
                        'component'=> 'Webhook'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'webhooks/register' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'webhooks/register',
                        'method' => 'register',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'webhooks/register',
                        'component'=> 'Webhook',
                    ],
                    /* Webhooks End */

                    /* Order Start */
                    CoreCommon::REST_URL_PREFIX . 'orders' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'orders',
                        'method' => 'createOrder',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'orders',
                        'component'=> 'Order'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'orders/batch' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'orders/batch',
                        'method' => 'batchUpdateOrders',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'orders/batch',
                        'component'=> 'Order'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'update_shipping_carrier' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'update_shipping_carrier',
                        'method' => 'updateShippingCarriers',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'update_shipping_carrier',
                        'component'=> 'Shipping'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'update_cedcommerce_order' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'update_cedcommerce_order',
                        'method' => 'updateCedcommerceOrder',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'update_cedcommerce_order',
                        'component'=> 'Order'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'updateOrderNote' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'updateOrderNote',
                        'method' => 'updateOrderNote',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'updateOrderNote',
                        'component'=> 'Order'
                    ],
                    CoreCommon::REST_URL_PREFIX . 'serverlessProcess' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'serverlessProcess',
                        'method' => 'serverlessProcess',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'serverlessProcess',
                        'class'=> 'App\Woocommercewebapi\Api\Serverless',
                        'required' => ['topic', 'data']
                    ],
                    /* Order End */
                ],
            ],
            'PUT' => [
                'routes' => [

                    /* Webhooks Start */
                    CoreCommon::REST_URL_PREFIX . 'webhooks/update-a-webhook' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'webhooks/update-a-webhook',
                        'method' => 'updateWebhook',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'webhooks/update-a-webhook',
                        'component'=> 'Webhook',
                        'required' => ['topic']
                    ],
                    /* Webhooks End */

                    /* Order Start */
                    CoreCommon::REST_URL_PREFIX . 'orders/update-an-order' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'orders/update-an-order',
                        'method' => 'updateOrder',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'orders/update-an-order',
                        'component'=> 'Order',
                        'required' => ['order_id']
                    ], 

                    CoreCommon::REST_URL_PREFIX . 'product/update-a-product' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'product/update-a-product',
                        'method' => 'updateProduct',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'product/update-a-product',
                        'component'=> 'Product',
                        'required' => ['product_id']
                    ], 


                    CoreCommon::REST_URL_PREFIX . 'product/update-a-product-variation' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'product/update-a-product-variation',
                        'method' => 'updateProductVariation',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'product/update-a-product-variation',
                        'component'=> 'Product',
                        'required' => ['product_id', 'variation_id']
                    ],
                    CoreCommon::REST_URL_PREFIX . 'inventory/reduce-inventory' => [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'inventory/reduce-stock',
                        'method'    => 'reduceStock',
                        'resource'  => CoreCommon::REST_URL_PREFIX . 'inventory/reduce-stock',
                        'component' => 'Inventory'
                    ]
                    /* Order End */
                ],
            ],
            'DELETE' => [
                'routes' => [
                    CoreCommon::REST_URL_PREFIX . 'user/delete' => [
                        'url'       => CoreCommon::REST_URL_PREFIX . 'user/delete',
                        'method'    => 'deleteUserShop',
                        'resource'  => 'user/delete',
                        'component' => 'User'
                    ],
                    /* Webhooks Start */
                    CoreCommon::REST_URL_PREFIX . 'webhooks/delete-a-webhook' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'webhooks/delete-a-webhook',
                        'method' => 'deleteWebhook',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'webhooks/delete-a-webhook',
                        'component'=> 'Webhook',
                        'required' => ['topic']
                    ],
                    CoreCommon::REST_URL_PREFIX . 'webhooks/unregister' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'webhooks/unregister',
                        'method' => 'unregister',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'webhooks/unregister',
                        'component'=> 'Webhook'
                    ],
                    /* Webhooks End */

                    /* Order Start */
                    CoreCommon::REST_URL_PREFIX . 'orders/delete-an-order' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'orders/delete-an-order',
                        'method' => 'deleteOrder',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'orders/delete-an-order',
                        'component'=> 'Order',
                        'required' => ['order_id']
                    ]
                    /* Order End */
                ],
            ]
        ],
    ],
];

