<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

return [
    'marketplace-modules' => [
        'woocommerce' => 'Woocommercewebapi',
    ],
    'webhooks'=>[
        'woocommerce' => [
            [
                'code' => 'woocommerce_product_created',
                'topic' => 'product.created',
            ],
            [
                'code' => 'woocommerce_product_deleted',
                'topic' => 'product.deleted',
            ],
            [
                'code' => 'woocommerce_product_update',
                'topic' => 'product.updated',
            ],
            [
                'code' => 'woocommerce_orders_updated',
                'topic' => 'order.updated',
            ],
            [
                'code' => 'woocommerce_orders_created',
                'topic' => 'order.created',

            ]
        ]
    ],
    'event_webhook'=>[
        'woocommerce'=>[
            [
                'title'=>"Event for Product Create",
                'type'=>"user",
                'event_code'=>"product.created",
                'event_handler'=>"sqs"
            ],
            [
                'title'=>"Event for Product Delete",
                'type'=>"user",
                'event_code'=>"product.deleted",
                'event_handler'=>"sqs"
            ],
            [
                'title'=>"Event for Product Update",
                'type'=>"user",
                'event_code'=>"product.updated",
                'event_handler'=>"sqs"                
            ],
            [
                'title'=>"Event for Orders Update",
                'type'=>"user",
                'event_code'=>"order.updated",
                'event_handler'=>"sqs"
            ],
            [
                'title'=>"Event for Orders Create",
                'type'=>"user",
                'event_code'=>"order.created",
                'event_handler'=>"sqs"
            ]
        ]
    ]
];