<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Components\Webhook;

use Exception;
use Aws\Sqs\SqsClient;
use Aws\Exception\AwsException;
use App\Woocommercewebapi\Components\Core\Common;

/**
 * Class Sqs
 * @package App\Woocommercewebapi\Components\Webhook
 */
class Sqs extends Common
{
    const DELAY_SECONDS = 0;

    const MAXIMUM_MESSAGE_SIZE = 200000; // 4 KB

    const  VISIBILITY_TIMEOUT = 2 * 60; // 2 min max time to process the message

    private $_data = null;

    private $_sqsClient = null;

    /**
     * @param $data
     * @return array
     */
    public function createQueue($data)
    {
        $this->_data = $data;
        try {
            $queueUrl = $this->getQueueUrl();
            if($queueUrl === false) {
                $result = $this->getClient()->createQueue([
                    'QueueName'  => $data['queue_name'],
                    'Attributes' => [
                        'DelaySeconds'       => self::DELAY_SECONDS,
                        'MaximumMessageSize' => self::MAXIMUM_MESSAGE_SIZE,
                        'VisibilityTimeout' => self::VISIBILITY_TIMEOUT, // 2 min max time to process the message
                    ]
                ]);
                $queueUrl = $result->get('QueueUrl');
            }

            if($queueUrl)
            {
                return [
                    'success'   => true,
                    'queue_url'  => $queueUrl
                ];
            } else {
                return [
                    'success'    => false,
                    'message'        => 'Something went wrong in sqs'
                ];
            }
        } catch (AwsException $e){
            return [
                'success'    => false,
                'message'        => 'Sqs credentials are not valid',
                'error'      => $e->getAwsErrorMessage()
            ];
        } catch (Exception $e){
            return [
                'success'   => false,
                'message'       => 'Sqs credentials are not valid',
                'error'     => $e->getMessage()
            ];
        }
    }

    /**
     * @return bool
     */
    public function getQueueUrl()
    {
        $data = $this->_data;
        $queueName = $data['queue_name'];
        $result = $this->getClient($data)->listQueues(array(
            'QueueNamePrefix' => $queueName
        ));

        $queueUrl = false;
        if ($queues = $result->getPath('QueueUrls')) {
            $queueUrl = $queues[0];
        }
        return $queueUrl;
    }

    public function getClient()
    {
        $data = $this->_data;
        if(is_null($this->_sqsClient))
        {
            $config = [
                'version'     => 'latest',
                'region'      => $data['queue_config']['region'],
                'credentials' => [
                    'key'    => $data['queue_config']['key'],
                    'secret' => $data['queue_config']['secret']
                ]
            ];

            $this->_sqsClient = new SqsClient($config);
        }

        return $this->_sqsClient;
    }
}
