<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Components;

use App\Woocommercewebapi\Components\Core\Common;

/**
 * Get shop details.
 *
 * @since 1.0.0
 */
class User extends Common {

    /**
     * Will delete user shop.
     *
     * @param array $data array containing the request data.
     * @since 1.0.0
     * @return array
     */
    public function deleteUserShop($data)
    {
        if ( ! empty( $data['remote_shop_id'] ) && ! empty( $data['group_code'] ) ) {
            $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo')
            ->getCollectionForTable( 'apps_shop' )
            ->deleteOne(
                [
                    '_id'        => (string) $data['remote_shop_id'],
                    'group_code' => $data['group_code']
                ]
            );
            return [
                'success' => true,
                'message' => 'User shop deleted successfully.'
            ];
        }
        return [
            'success' => false,
            'message' => 'Required details missing to delete shop.'
        ];
    }
}
