<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Components;

use App\Woocommercewebapi\Components\Core\Common;
// use Exception;

/**
 * Get shop details.
 *
 * @since 1.0.0
 */
class Shop extends Common {

    /**
     * Get Shop.
     *
     * @param array $params array containing the request params containing the filters.
     * @since 1.0.0
     * @return array array containing the status of the request and the data.
     */
    public function get( $params = [] ) {
        $shoData = $this->getCurrentShopData();
        if(isset($shoData['token_data']['connection_stage']) && $shoData['token_data']['connection_stage']=="partial"){
            $shopData = $shoData['token_data'] ?? [];
            unset($shopData['consumer_key'], $shopData['consumer_secret']);
        } else {
            $shopData = $shoData['token_data']['user_detail'] ?? [];
        }
        if( empty( $shopData ) ) {
            return [
                'success' => false,
                'data'    => []
            ];
        }
        $userName = $shopData['username'] ?? '';
        if (! empty($shoData['token_data']['new_schema'])) {
            $this->formatDomain($userName);
            $shopData['username'] = $userName;
        }
        return [
            'success' => true,
            'data'    => $shopData
        ];
    }
}
