<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Components;
use App\Woocommercewebapi\Components\Core\Common As CoreCommon;
/**
 * Class Product
 * @package App\Woocommercewebapi\Components
 */
class Shipping extends CoreCommon {

     public function getShippingMethod()
     {
          $response = $this->rest(
               'GET',
               '/wp-json/wc/v3/shipping_methods',
               [],
               []
          );
          return [
               'success' => $this->success,
               'data'    => $response
          ];
     }

     /**
      * Function to update shipping carriers on woocommerce
      *
      * @param array $data
      * @return void
      */
     public function updateShippingCarriers( $data ) {
          $response = $this->rest(
               'POST',
               self::UPDATE_SHIPPING_CARRIER,
                $data,
               []
          );
          return [
              'success' => $this->success,
              'data'    => $response
          ];
     }
}
