<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Components;
use App\Woocommercewebapi\Components\Core\Common As CoreCommon;

/**
 * Class Product
 * @package App\Woocommercewebapi\Components
 */
class Serverless extends CoreCommon {
    
   

    /**
     * Post Serverless Data.
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function serverlessProcess($data = []) {
        
        $topic = !empty($data['topic']) ? $data['topic'] : false;
        $post_data = !empty($data['data']) ? $data['data'] : false;

        $response = $this->rest(
            'POST',
            self::WOOCOMMERCE_SERVERLESS_ENDPOINT.$topic,
            $post_data,
            []
        );
        return [
            'success' => $this->success,
            'data'    => $response
        ];
    }

}