<?php

namespace App\Woocommercewebapi\Components\Route;

use App\Apiconnect\Components\Authenticate\HandlerInterface;
use App\Woocommercewebapi\Components\Core\Common;

/**
 * Class Handler
 * @package App\Woocommercewebapi\Components\Route
 */
class Handler extends Common implements HandlerInterface {

    /**
     * get the redirect url.
     *
     * @param array $postData
     * @return void
     */
    public function requestRedirectAuthUrl( $postData ) {
        $auth = $this->di->getObjectManager()->get('\App\Woocommercewebapi\Components\Authenticate')->fetchAuthenticationUrl($postData);
        return $auth;
    }

    /**
     * Process the authentication
     *
     * @return array
     */
    public function processAuth() {
        $postData = $this->di->getRequest()->get();
        
        unset( $postData['_url'] );
        unset( $postData['sAppId'] );
       
        $tokenInfo = $this->di->getObjectManager()->get('\App\Woocommercewebapi\Components\Authenticate')->requestAccessToken( $postData );
        $appConfig = $this->di->getRegistry()->getAppConfig();
        
        if($tokenInfo['success']) {
            $woocommerceDomain = rtrim(trim($tokenInfo['token'][self::WOOCOMMERCE_DOMAIN_FIELD_NAME]),'/');
            $apiConnectAppShop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop');
            $previousShop      = $apiConnectAppShop->getShop(
                false,
                false,
                [
                    self::WOOCOMMERCE_DOMAIN_FIELD_NAME => $woocommerceDomain,
                    'group_code'                        => $appConfig['group_code']
                ],
                [
                    'domain',
                    'group_code'
                ]
            );
            $newShop = empty($previousShop['success']);
            if ($newShop) {
                $this->formatDomain($woocommerceDomain);
                $tokenInfo['token']['new_schema'] = true;
            }
            $consumerKey    = trim($tokenInfo['token'][self::CONSUMER_KEY_FIELD_NAME]);
            $consumerSecret = trim($tokenInfo['token'][self::CONSUMER_SECRET_FIELD_NAME]);
            $response       = $apiConnectAppShop->addShop(
                [
                    self::WOOCOMMERCE_DOMAIN_FIELD_NAME     => $woocommerceDomain,
                    self::CONSUMER_KEY_FIELD_NAME           => $consumerKey,
                    self::CONSUMER_SECRET_FIELD_NAME        => $consumerSecret,
                    'marketplace'                           => $appConfig['marketplace'],
                    'token_data'                            => $tokenInfo['token'],
                    'is_private'                            => true
                ],
                [self::WOOCOMMERCE_DOMAIN_FIELD_NAME]
            );
            if(isset($postData['connection_stage'])){
                $response['data']['connection_stage'] = $postData['connection_stage'];
            }else{
                $response['data']['connection_stage'] = "completed";
            }
            return $response;
        }

        return $tokenInfo;
    }
}
