<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Components;

use App\Woocommercewebapi\Components\Core\Common As CoreCommon;

/**
 * Class Order
 * @package App\Woocommercewebapi\Components
 */
class Order extends CoreCommon
{
    /**
     * @param array $data
     * @return mixed
     */

    public function getAllOrders($data = []) {
        $response = $this->rest(
            'GET',
            self::LIST_ALL_ORDERS_END_POINT,
            $data,
            []
        );
        return [
            'success' => $this->success,
            'data'    => $response
        ];
    }

    /**
     * @param array $data
     * @return mixed
     */
    public function getOrderById($data = []) {
        $endPoint = str_replace(
            '{order_id}',
            $data['order_id'],
            self::RETRIEVE_AN_ORDER_END_POINT
        );
        return $this->rest(
            'GET',
            $endPoint,
            $data,
            []
        );
    }

    /**
     * @param array $data
     * @return mixed
     */
    public function createOrder($data = []) {
        $this->di->getLog()->logContent( 'createOrderWoocommerceRemote::OrderPayload: Order Payload - ' . json_encode( $data ), 'info', 'woocommerce'  . DS .  $this->di->getUser()->id  . DS . 'order' . date( 'Y-m-d' ) . '-orderpayload.log' );
        $response = $this->rest(
            'POST',
            self::CREATE_AN_ORDER_END_POINT,
            $data,
            []
        );
        return
        [
            'success' => $this->success,
            'data'    => $response
        ];
    }

    /**
     * @param array $data
     * @return mixed
     */
    public function updateOrder($data = []) {

        $payload = $data['data'];
        $endPoint = str_replace(
            '{order_id}',
            $data['order_id'],
            self::UPDATE_AN_ORDER_END_POINT
        );
        $response = $this->rest(
            'PUT',
            $endPoint,
            $payload,
            []
        );
        return
        [
            'success' => $this->success,
            'data'    => $response
        ];
    }

    /**
     * @param array $data
     * @return mixed
     */
    public function updateCedcommerceOrder($data = []) {
        $endPoint = self::UPDATE_CEDCOMMERCE_ORDER_DATA;
        return $this->rest(
            'POST',
            $endPoint,
            $data,
            []
        );
    }

    /**
     * @param array $data
     * @return mixed
     */
    public function deleteOrder($data = []) {
        $endPoint = str_replace(
            '{order_id}',
            $data['order_id'],
            self::DELETE_AN_ORDER_END_POINT
        );
        return $this->rest(
            'DELETE',
            $endPoint,
            $data,
            []
        );
    }

    /**
     * @param array $data
     * @return mixed
     */
    public function batchUpdateOrders($data = []) {
        return $this->rest(
            'POST',
            self::BATCH_UPDATE_ORDERS_END_POINT,
            $data,
            []
        );
    }

    /**
     * Function to update shipping carriers on woocommerce
     *
     * @param array $data contains target carriers
     * @return void
     */
    public function updateShippingCarriers( $data ) {
        $response = $this->rest(
            'POST',
            '/wp-json/cedcommerce/v1/update_shipping_carrier',
            $data,
            []
        );
        return [
            'success' => $this->success,
            'data' => $response
        ];
    }

    /**
     * Function to get Order Status
     *
     * @return array
     */
    public function getOrderStatus(){
        $endPoint = self::GET_ORDER_STATUS;
        $response = $this->rest(
            'GET',
            $endPoint,
            [],
            []
        );
        return [
            'success' => $this->success,
            'data' => $response
        ];

    }


    /**
     * Function to update Order Note on woocommerce
     *
     * @param array $data contains params to update
     * @return void
     */
    public function updateOrderNote( $data = [] ) {

        $payload['note'] = $data['msg'];
        $endPoint = str_replace(
            '{order_id}',
            $data['order_id'],
            self::UPDATE_ORDER_NOTE
        );
        $response = $this->rest(
            'POST',
            $endPoint,
            $payload,
            []
        );
        return[
            'success' => $this->success,
            'data'    => $response
        ];
    }

    public function getOrderStatusses(){
        $endPoint = self::GET_ORDER_STATUS;
        $response = $this->rest(
            'GET',
            $endPoint,
            [],
            []
        );
        return [
            'success' => $this->success,
            'data' => $response
        ];

    }

    public function getTaxes(){
        $endPoint = self::GET_TAXES;
        $response = $this->rest(
            'GET',
            $endPoint,
            [],
            []
        );
        return [
            'success' => $this->success,
            'data' => $response
        ];

    }

    public function getTaxesById($data){
        $endPoint = str_replace(
            '{tax_id}',
            $data['tax_id'],
            self::GET_A_TAXES
        );
        $response = $this->rest(
            'GET',
            $endPoint,
            [],
            []
        );
        return [
            'success' => $this->success,
            'data' => $response
        ];

    }


        /**
     * Function to get Tax classes from woocommerce
     *
     * @return array
     */
    public function getTaxClasses() {
        $response = $this->rest(
            'GET',
            self::GET_TAX_CLASSES,
            [],
            []
        );
        return [
            'success' => $this->success,
            'data' => $response
        ];
    }
}