<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Components;
use App\Woocommercewebapi\Components\Core\Common As CoreCommon;

/**
 * Class Inventory
 * @package App\Woocommercewebapi\Components
 */
class Inventory extends CoreCommon {

    /**
     * Array containing the request param.
     *
     * @param array $params
     * @since 1.0.0
     * @return array
     */
    public function reduceStock( $params = array() ) {
        $response = $this->rest(
            'PUT',
            '/wp-json/wc/v3/ced/product_quantity',
            $params,
            []
        );
        return [
            'success' => $this->success,
            'data'    => $response
        ];
    }
}