<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Components;

use App\Woocommercewebapi\Components\Core\Common As CoreCommon;

/**
 * Class Customer
 * @package App\Woocommercewebapi\Components
 */
class Customer extends CoreCommon
{
    /**
     * @param array $data
     * @return mixed
     */
    public function getCustomers($data = []) {
        return $this->rest(
            'GET',
            self::LIST_ALL_CUSTOMERS_END_POINT,
            $data,
            []
        );
    }

    /**
     * @param array $data
     * @return mixed
     */
    public function getCustomerById($data = []) {
        $endPoint = str_replace(
            '{customer_id}',
            $data['customer_id'],
            self::RETRIEVE_AN_CUSTOMER_END_POINT
        );

        return $this->rest('GET', $endPoint, $data, []);
    }

}