<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Components;

use App\Woocommercewebapi\Components\Core\Common As CoreCommon;
use Exception;
/**
 * Class Authenticate
 * @package App\Woocommercewebapi\Components
 */
class Authenticate extends CoreCommon
{
      /**
     * The redirect url.
     *
     * @var string
     */
    protected $redirectUrl;

    /**
     * @param array $data
     * @return array
     */
    public function addDomainInformation($data = []) {
        $woocommerceDomain = trim($data[self::WOOCOMMERCE_DOMAIN_FIELD_NAME]);
        $consumerKey = trim($data[self::CONSUMER_KEY_FIELD_NAME]);
        $consumerSecret = trim($data[self::CONSUMER_SECRET_FIELD_NAME]);
        if ($woocommerceDomain && $consumerKey && $consumerSecret) {
            $response = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(
                [
                    self::WOOCOMMERCE_DOMAIN_FIELD_NAME => $woocommerceDomain,
                    self::CONSUMER_KEY_FIELD_NAME => $consumerKey,
                    self::CONSUMER_SECRET_FIELD_NAME => $consumerSecret
                ],
                [self::WOOCOMMERCE_DOMAIN_FIELD_NAME]
            );
            return $response;
        }
        return [
          'success' => false,
          'message' => 'Unable to Authenticate.'
        ];
    }

    
    /**
     * Get the auth url.
     *
     * @param array $postData posted data for authoriation.
     * @return array
     */
    public function fetchAuthenticationUrl( $postData )
    {
        try{
            $response = $this->getRedirectUrl($postData);
            
            if( ! $response['success'] ) {
                return [
                    'success' => true,
                    'authUrl' => $this->redirectUrl
                ];
            }
            else{
                return [
                    'success' => true,
                    'authUrl' => $response['authUrl']
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        } 
    }

    /**
     * Get app redirect url.
     *
     * @param array $postData
     * @return array
     */
    public function getRedirectUrl( $postData ) {
        try{
            $appcredentials = $this->getAppCredentials();
            $this->redirectUrl = $appcredentials['redirect_uri'];
            if ( ! $this->redirectUrl ) {
                return [
                    'success' => false,
                    'msg' => 'Oops! Redirect is missing'
                ];
            }
            $postData = $this->getAllowedDataForShop( $postData );
            $authUrl = $this->redirectUrl .'&' . http_build_query( $postData );
            
            
            $result = array(
                'success' => true,
                'authUrl' =>  $authUrl
            );
            return $result;
        }catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

     /**
      * Get the access token from Magento.
      *
      * @param array $postData
      * @return array
      */
    public function requestAccessToken( $postData )
    {
        try{
            if ($postData[self::CONSUMER_KEY_FIELD_NAME] === null || $postData[self::CONSUMER_KEY_FIELD_NAME] === '') {
                throw new Exception('Oops! Consumer key is missing');
            }
            elseif ($postData[self::CONSUMER_SECRET_FIELD_NAME] === null || $postData[self::CONSUMER_SECRET_FIELD_NAME] === '') {
                throw new Exception('Oops! store url is missing');
            }
            $response = $this->getAllowedDataForShop( $postData );
            return ['success' => true, 'token' => $response ];
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * filter allowed data for shop.
     * @param array $data data for filter.
     * @since 1.0.0
     * @return array
     */
    public function getAllowedDataForShop( $data = [] ) {
        
        $allowed_data = [
            'domain', 
            'consumer_key', 
            'consumer_secret', 
            'user_detail',
            'connection_stage',
            'state'
        ];
        if(!empty( $data ) && is_array( $data ) ) {
            foreach( $data as $key => $value ) {
           
                if( ! in_array( $key, $allowed_data ) ) {
                    unset( $data[ $key ] );
                }
            }
        }
        
        return $data;
    }
}