<?php
namespace App\Woocommercewebapi\Api;
use App\Woocommercewebapi\Components\User as ComponentUser;
/**
 * Handles User Requests.
 *
 * @since 1.0.0
 */
class User extends Base {

    /**
     * Current component name, will be used by etc/webapi.php to call the respective class.
     *
     * @var string
     * @since 1.0.0
     */
    protected $_component = 'User';

    /**
     * Will call component to delete user shop.
     *
     * @param array $data array contining the request data.
     * @since 1.0.0
     * @return array
     */
    public function deleteUserShop($data)
    {
        try{
            if(! $this->di->getRegistry()->getCurrentShop()) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }
            return $this->di->getObjectManager()->get(ComponentUser::class)->deleteUserShop($data);
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
}