<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Api;

use App\Woocommercewebapi\Api\Base;
use App\Woocommercewebapi\Components\Shipping As ComponentShipping;

/**
 * Will handle Shipping.
 *
 * @since 1.0.0
 */
class Shipping extends Base
{

     public function updateShippingCarriers( $data ) {

          $finaldata['marketplace']      = $data['marketplace'];
          $finaldata['data']             = $data['data'];
          try{
              if(! $this->di->getRegistry()->getCurrentShop()) {
                  return [
                      'success' => false,
                      'message' => ComponentShipping::SHOP_NOT_FOUND_ERROR_MESSAGE
                  ];
              }
              return $this->di->getObjectManager()->get(ComponentShipping::class)->updateShippingCarriers($finaldata);
                  
          } catch (\Exception $exception) {
              return [
                  'success' => false,
                  'message' => $exception->getMessage()
              ];
          }
     }

     public function getWoocommerceCarrier() {
          try {
               if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                         'success' => false,
                         'message' =>'shop not found!!'
                    ];
               }

               return $this->di->getObjectManager()->get( ComponentShipping::class )->getShippingMethod();
               } catch ( \Exception $e ) {
               return [
                    'success' => false,
                    'message' => $e->getMessage()
               ];
               }
     }

}