<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Api;

use App\Woocommercewebapi\Api\Base;
use App\Woocommercewebapi\Components\Serverless As ComponentServerless;
/**
 * Will handle Serverless requests.
 *
 * @since 1.0.0
 */
class Serverless extends Base
{
    /**
     * @var string
     */
    protected $_component = 'Serverless';

     /**
     * Process Serverless Operations.
     *
     * @param array $params array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function serverlessProcess($params = array()) {
            return $this->di->getObjectManager()->get(ComponentServerless::class)->serverlessProcess($params);
        
    }
    
}