<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Api;

use App\Woocommercewebapi\Api\Base;
use App\Woocommercewebapi\Components\Order As ComponentOrder;
use PhpParser\Node\Expr\FuncCall;

/**
 * Class Order
 * @package App\Woocommercewebapi\Api
 */
class Order extends Base
{
    /**
     * @var string
     */
    protected $_component = 'Order';

    /**
     * @param array $data
     * @return array
     */
    public function getAllOrders($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->isAuthenticated()) {
                    return [
                        'success' => false,
                        'message' => ComponentOrder::AUTHENTICATION_ERROR_MESSAGE
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentOrder::class)->getAllOrders($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getOrderById($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                // if (!$this->isAuthenticated()) {
                //     return [
                //         'success' => false,
                //         'message' => ComponentOrder::AUTHENTICATION_ERROR_MESSAGE
                //     ];
                // }
                return $this->di->getObjectManager()->get(ComponentOrder::class)->getOrderById($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function createOrder($data = []) {


        try{
            if(! $this->di->getRegistry()->getCurrentShop()) {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
            return $this->di->getObjectManager()->get(ComponentOrder::class)->createOrder($data);
            
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function updateOrder($data = []) {
        try{
            if(! $this->di->getRegistry()->getCurrentShop()) {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
            return $this->di->getObjectManager()->get(ComponentOrder::class)->updateOrder($data);
            
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function updateCedcommerceOrder($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                // if (!$this->isAuthenticated()) {
                //     return [
                //         'success' => false,
                //         'message' => ComponentOrder::AUTHENTICATION_ERROR_MESSAGE
                //     ];
                // }
                return $this->di->getObjectManager()->get(ComponentOrder::class)->updateCedcommerceOrder($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function deleteOrder($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->isAuthenticated()) {
                    return [
                        'success' => false,
                        'message' => ComponentOrder::AUTHENTICATION_ERROR_MESSAGE
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentOrder::class)->deleteOrder($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function batchUpdateOrders($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->isAuthenticated()) {
                    return [
                        'success' => false,
                        'message' => ComponentOrder::AUTHENTICATION_ERROR_MESSAGE
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentOrder::class)->batchUpdateOrders($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * Function to get woocommerce order status
     *
     * @return array
     */
    public function getOrderStatus( ) {
        try{
            if(! $this->di->getRegistry()->getCurrentShop()) {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
            return $this->di->getObjectManager()->get(ComponentOrder::class)->getOrderStatus();
            
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }

    }

    /**
     * Function to update order note on woocommerce
     *
     * @param array $data contains payload to update in note
     * @return array
     */
    public function updateOrderNote( $data ) {

        try{
            if(! $this->di->getRegistry()->getCurrentShop()) {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }

            $data = $data['data'];
            if( empty( $data['order_id'] )  ) {
                return [
                    'success' => false,
                    'message' => 'Order Id is Required'
                ];
            }
            return $this->di->getObjectManager()->get(ComponentOrder::class)->updateOrderNote( $data );
            
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    public function getOrderStatusses($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                return $this->di->getObjectManager()->get(ComponentOrder::class)->getOrderStatusses($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
    
    public function getTaxes($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                return $this->di->getObjectManager()->get(ComponentOrder::class)->getTaxes($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    public function getTaxesById($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                return $this->di->getObjectManager()->get(ComponentOrder::class)->getTaxesById($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * Function to get woocommerce tex classes
     *
     * @return array
     */
    public function getTaxClasses() {
        try{
            if(! $this->di->getRegistry()->getCurrentShop()) {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
            return $this->di->getObjectManager()->get(ComponentOrder::class)->getTaxClasses();
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
    
}