<?php
namespace App\Woocommercewebapi\Api;
use Aws\DynamoDb\DynamoDbClient;

class Notification extends Base
{
    protected $_component = 'Notification';

    public function createDestination($data){
        try{
            $appConfig =  $this->di->getRegistry()->getAppConfig();
            $targetMarketplace = $this->di->getConfig()->get('marketplace-modules')->get($appConfig['marketplace']) ?: ucfirst($appConfig['marketplace']);

            $model = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $options = [
                "typeMap" => ['root' => 'array', 'document' => 'array']
            ];
            $collection = $model->getCollection('marketplace_destination');
            $handler = $this->di->getObjectManager()->get('App\\'.$targetMarketplace.'\\Api\Base');
            $uniqueKeys = $handler->getDestinationUniqueKeys();
            foreach ($uniqueKeys as $key) {
                if (isset($data['event_data'][$key])) {
                    $filters["{$key}"] = $data['event_data'][$key];
                }
            }
            $marketplace_destination = $collection->findOne($filters, $options);

            if (empty($marketplace_destination)){
                    $destinationId = "woocommerce_destination_id";
                    if ($destinationId){
                        $insertData = [
                            '_id' => $model->getCounter('marketplace_destination_id'),
                            'title' =>$data['event_data']['title'] ?? "",
                            'type' => $data['event_data']['type'],
                            'event_handler' => $data['event_data']['event_handler'],
                            'destination_id'=> $destinationId
                        ];
                        $collection->insertOne($insertData);
                        return ['success'=>true,'destination_id'=>$destinationId,'message'=>"Marketplace destination created successfully"];
                    }
            }else{
                return ['success'=>true,'destination_id'=>$marketplace_destination['destination_id'],'message'=>"Marketplace destination already created"];
            }
        }
        catch(\Exception $e){
            return [
                'success' => false,
                'data' => $data,
                'msg' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }

    public function createSubscription($data){
        $shop = $this->di->getRegistry()->getCurrentShop();
        $appConfig = $this->di->getRegistry()->getAppConfig();
        $app_shop = $this->di->getObjectManager()->get('App\Apiconnect\Models\Apps\Shop')->getAppInShopById($shop['_id'], $appConfig['_id']);

        $this->di->getLog()->logContent('Notification:Create-Subscription:Data-Received:Shop => '.json_encode($shop), 'info', 'woocommerce-notification.log');
        $this->di->getLog()->logContent('Notification:Create-Subscription:Data-Received:AppConfig => '.json_encode($appConfig), 'info', 'woocommerce-notification.log');
        $this->di->getLog()->logContent('Notification:Create-Subscription:Data-Received:AppShop => '.print_r($app_shop, true), 'info', 'woocommerce-notification.log');

        // $id = $appConfig['_id'];
        $id = $shop['_id'];
        $appId = $shop['apps'][0]['cif_app_id'];
        $consumer_secret = $shop['apps'][0]['consumer_secret'];

        $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');

        // customize dynamo tables for your project with concept `prefix`
        $prefix = $this->di->getConfig()->get('add_dynamo_prefix') ? $this->di->getConfig()->get('app_code') : "";
        $tableName = empty($prefix) ? "apps" : $prefix."_apps";

        $client->putItem([
            'Item' => [ // REQUIRED
                'id' => [
                    'N' => (string)$id,
                ],
                'app_id' => [
                    'S' => (string)$appId,
                ],
                'app_secret' => [
                    'S' => $consumer_secret,
                ],
                'marketplace' => [
                    'S' => $appConfig['marketplace']
                ],
                'domain' => [
                    'S' => $shop['domain'] ?? false
                ]
            ],
            'TableName' => $tableName, // REQUIRED
        ]);

        $baseWebhookUrl = $this->di->getConfig()->get('updated_base_webhook_url')->get($appConfig['marketplace']);
        $baseWebhookUrl = $baseWebhookUrl."?shop_id=".$shop['_id']."&topic=".$data['event_code'];
        if(!empty($prefix)){
            $baseWebhookUrl = $baseWebhookUrl."&prefix=".$prefix;
        }

        $webhookData = [
                'topic'        => $data['event_code'],
                'delivery_url' => $baseWebhookUrl,
                'secret'       => $consumer_secret
            ];
        $object = $this->di->getObjectManager()->get('\App\Woocommercewebapi\Components\Webhook');
        $response = $object->createWebhook($webhookData);
        $this->di->getLog()->logContent('woocommerce response = '.print_r($response,true)." webhookData = ".print_r($webhookData,true),'critical','woocommerce/subs_create.log');
        return ['success'=>true,'subscription_id'=>$response['data']['id'] ?? null];
    }

    public function getApiMode($request_data)
    {
        if(isset($request_data['sandbox']) && $request_data['sandbox']) $mode = 'sandbox';
        else $mode = 'live';

        return $mode;
    }

    public function deleteSubscription($data){
        $object = $this->di->getObjectManager()->get('\App\Woocommercewebapi\Components\Webhook');
        $response = $object->deleteWebhook(['id'=>$data['subscription_id']]);
        $this->di->getLog()->logContent('woocommerce response = '.print_r($response,true)." webhookData = ".print_r($data,true),'critical','woocommerce/subs_delete.log');
        if (isset($response['success']) && $response['success']){
            $model = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $collection = $model->getCollection('marketplace_subscription');
            $collection->deleteOne(
                ['marketplace_subscription_id' => (string)$data['subscription_id']]
            );
            return ['success'=>true,"message"=>"Marketplace subscription deleted successfully"];
        }else{
            return ['success'=>true,"message"=>"Something went wrong in deleting marketplace subscription"];
        }
    }

}

