<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Api;

use App\Woocommercewebapi\Api\Base;
use App\Woocommercewebapi\Components\Inventory As ComponentInventory;

/**
 * Will handle inventory requests.
 *
 * @since 1.0.0
 */
class Inventory extends Base {

    /**
     * @var string
     */
    protected $_component = 'Inventory';

    /**
     * Get all products from woocommerce.
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function reduceStock( $data = [] ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'message' => ComponentInventory::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }

            return $this->di->getObjectManager()->get( ComponentInventory::class )->reduceStock( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
        }
    }
}