<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Api;

use App\Woocommercewebapi\Api\Base;
use App\Woocommercewebapi\Components\Data As ComponentData;

/**
 * Class Data
 * @package App\Woocommercewebapi\Api
 */
class Data extends Base
{
    /**
     * @var string
     */
    protected $_component = 'Data';

    /**
     * @param array $data
     * @return array
     */
    public function getCurrentCurrency($data = []) {

        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'message' => ComponentData::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }

            return $this->di->getObjectManager()->get(ComponentData::class)->getCurrentCurrency($data);

        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
        }
    }
}