<?php
namespace App\Woocommercewebapi\Api;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */

use App\Woocommercewebapi\Api\Base;
use App\Woocommercewebapi\Components\Customer As ComponentCustomer;

class Customer extends Base
{
    protected $_component = 'Customer';

    public function getCustomers($data)
    {

        try {

            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'message' => ComponentCustomer::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
            return $this->di->getObjectManager()->get(ComponentCustomer::class)->getCustomers( $this->getFilteredParams( $data ));
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }


    public function getCustomerById($data)
    {

        try {

            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'message' => ComponentCustomer::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
            return $this->di->getObjectManager()->get(ComponentCustomer::class)->getCustomerById( $this->getFilteredParams( $data ));
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}