<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Api;
use App\Woocommercewebapi\Components\Core\Common As WooCommerceCoreCommon;

/**
 * Class Base
 * @package App\Woocommercewebapi\Api
 */
class Base extends \App\Apiconnect\Api\Base {

    /**
     * Get filtered params by removing the default params from the params recieved array.
     *
     * @param array $data
     * @since 1.0.0
     * @return array
     */
    public function getFilteredParams( $data ) {
        $default_params = [ '_url', 'appId', 'shop_id', 'sAppId', 'sales_channel' ];
        foreach ( $default_params as $key ) {
            unset( $data[ $key ] );
        }

        return $data;
    }

    public function getDestinationUniqueKeys(){
        return ['event_handler','type'];
    }

    public function getSubscriptionUniqueKeys(){
        return ['_id','event_code'];
    }

    /**
     * @return bool
     */
    public function isAuthenticated() {
        $shop = $this->di->getRegistry()->getCurrentShop();
        if (
            isset($shop['apps'][0][WooCommerceCoreCommon::WOOCOMMERCE_DOMAIN_FIELD_NAME]) &&
            isset($shop['apps'][0][WooCommerceCoreCommon::CONSUMER_KEY_FIELD_NAME]) &&
            isset($shop['apps'][0][WooCommerceCoreCommon::CONSUMER_SECRET_FIELD_NAME])
        ) {
            return true;
        }
        return false;
    }
}