<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Woocommercewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Woocommercewebapi\Api;

use App\Woocommercewebapi\Api\Base;
use App\Woocommercewebapi\Components\Authenticate As ComponentAuthenticate;

/**
 * Class Authenticate
 * @package App\Woocommercewebapi\Api
 */
class Authenticate extends Base
{
    /**
     * @var string
     */
    protected $_component = 'Authenticate';

    /**
     * @param array $data
     * @return array
     */
    public function addDomainInformation($data = []) {
        try{
            return $this->di->getObjectManager()->get(ComponentAuthenticate::class)->addDomainInformation($data);
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function validateShop($data = []) {
        try{
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (in_array($data['sAppId'], $shop['sub_apps'])) {
                    if ($this->isAuthenticated()) {
                        return [
                            'success' => true,
                            'message' => 'Succeeded.',
                            'domain' => $shop[ComponentAuthenticate::WOOCOMMERCE_DOMAIN_FIELD_NAME]
                        ];
                    } else {
                        return [
                            'success' => false,
                            'message' => ComponentAuthenticate::AUTHENTICATION_ERROR_MESSAGE
                        ];
                    }
                }
                return [
                    'success' => false,
                    'message' => 'You are not allowed to access this shop.'
                ];
            } else {
                return [
                    'success' => false,
                    'message' => ComponentAuthenticate::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
}