<?php

namespace App\Webapi\Test\Controllers;

class RestControllerTest extends \App\Core\Components\UnitTestApp
{
    public function testSendNotification()
    {
        $appModel = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');
        $appConfig = $appModel->getSubConfig("1");
        $this->di->getRegistry()->setAppConfig($appConfig);
        $result = ['success' => true, 'message' => "Notification send successfully."];
        $user = $this->di->getObjectManager()->get('\App\Webapi\Controllers\RestController');
        $response = $user->sendNotification("unauthorized_access");

        $this->assertEquals(
            $response,
            $result
        );
    }

    public function testHandleApiCallAttempts()
    {
        $appModel = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');
        $cache = $this->di->getCache();
        //manual cache set
        $cache->set("44_shopifyTest_temp_block_count", 4);

        $appConfig = $appModel->getSubConfig("1");
        $this->di->getRegistry()->setAppConfig($appConfig);

        $shop = $this->di->getObjectManager()->get('\App\Apiconnect\Models\Apps\Shop')
            ->getById("44", "1", "1");

        if (!empty($shop)) {
            $this->di->getRegistry()->setCurrentShop($shop);
        }

        // case1: for temporarily block
        $output1 = [
            'success' => false,
            'message' => "Api calls permanently blocked for the current shop! Kindly contact to admin."
        ];

        // case2: permanently block
        $output2 = ['success' => false, 'message' => "Api calls temporarily blocked! Try after 30 mins."];

        $user = $this->di->getObjectManager()->get('\App\Webapi\Controllers\RestController');
        $response = $user->handleApiCallAttempts();

        $this->assertEquals(
            $response,
            $output2
        );
    }
}
