<?php

namespace App\Webapi\Components\Destination;

use Aws\Sqs\SqsClient;

class Sqs extends \App\Core\Components\Base
{
    public $client = false;

    public function sendNotificationToDestination($destination, $subscription)
    {
        $queueData = $subscription['queue_data'] ?? null;
        $clientCredentials['version'] = 'latest';
        $clientCredentials['region'] = $destination['destination_data']['sqs']['region'];
        $clientCredentials['credentials']['key'] = $destination['destination_data']['sqs']['key'];
        $clientCredentials['credentials']['secret'] = $destination['destination_data']['sqs']['secret'];
        if (isset(
            $queueData,
            $clientCredentials['version'],
            $clientCredentials['region'],
            $clientCredentials['credentials']['key'],
            $clientCredentials['credentials']['secret']
        )) {
            $client = new SqsClient($clientCredentials);
            $result =  $client->createQueue(array(
                'QueueName' => $queueData['queue_name'],
                'Attributes' => array(
                    'MaximumMessageSize' => 32 * 4096, // 4 KB
                    'VisibilityTimeout' => 5 * 60, // 2 min max time to process the message
                ),
            ));
            $queueUrl = $result->get('QueueUrl');
            $client->sendMessage(array(
                'QueueUrl' => $queueUrl,
                'MessageBody' => json_encode($queueData),
            ));
            return ['success' => true, 'message' => "Notification sent successfully."];
        }
        return ['success' => false, 'message' => "Trouble in sending notification."];
    }
}
