<?php
return [
    'restapi' => [
        'v1' => [
            'GET' => [
                'routes' => [
                    'shop/getscripts' => [
                        'url' => 'shop/getscripts',
                        'method' => 'getScripts',
                        'resource' => 'shop/getScripts',
                        'component' => 'Shop'
                    ],
                    'product/getProductMetafields' => [
                        'url' => 'product/getProductMetafields',
                        'method' => 'getProductMetafields',
                        'resource' => 'product/getProductMetafields',
                        'component' => 'Product',
                        'required' => ['id']
                    ],
                    'product/data' => [
                        'url' => 'product/data',
                        'method' => 'getProductAttributes',
                        'resource' => 'product/data',
                        'component' => 'Product',
                        'required' => ['field']
                    ],
                    'product/count' => [
                        'url' => 'product/count',
                        'method' => 'getProductCount',
                        'resource' => 'product/count',
                        'component' => 'Product',
                    ],
                    'shop/location' => [
                        'url' => 'shop/location',
                        'method' => 'get',
                        'resource' => 'location/get',
                        'component' => 'Location'
                    ],
                    'shop/location/inventory' => [
                        'url' => 'shop/location/inventory',
                        'method' => 'getInventory',
                        'resource' => 'location/getInventory',
                        'component' => 'Location',
                        'required' => ['id']
                    ],
                    'inventory' => [
                        'url' => 'inventory',
                        'method' => 'get',
                        'resource' => 'inventory/get',
                        'component' => 'Inventory',
                    ],
                    'webhook' => [
                        'url' => 'webhook',
                        'method' => 'get',
                        'resource' => 'webhook/get',
                        'component' => 'Webhook',
                    ],
                    'billing/recurring' => [
                        'url' => 'billing/recurring',
                        'method' => 'get',
                        'resource' => 'billing/recurring',
                        'component'=> 'Billing\Recurring',
                        // 'class' => 'App\Shopifywebapi\Api\Billing\Recurring',
                        // 'response_class' => 'App\Shopifywebapi\Api\Response\Billing\Recurring'
                    ],
                    'billing/onetime' => [
                        'url' => 'billing/onetime',
                        'method' => 'get',
                        'resource' => 'billing\onetime',
                        // 'component'=> 'Billing',
                        'class' => 'App\Shopifywebapi\Api\Billing\OneTime',
                        'response_class' => 'App\Shopifywebapi\Api\Response\Billing\OneTime'
                    ],
                    'fbapproval' => [
                        'url' => 'fbapproval',
                        'method' => 'getFbApprovalStatus',
                        'resource' => 'fbapproval',
                        'component' => 'Shop'
                    ],
                    'fbapproval/save' => [
                        'url' => 'fbapproval/save',
                        'method' => 'handleFbApprovalData',
                        'resource' => 'fbapproval/save',
                        'component' => 'Shop'
                    ],
                    'bulk/operation' => [
                        'url' => 'bulk/operation',
                        'method' => 'getBulkOperation',
                        'resource' => 'bulk/operation',
                        'component' => 'BulkOperation',
                    ],
                    'bulk/operation/item' => [
                        'url' => 'bulk/operation/product',
                        'method' => 'getBulkItem',
                        'resource' => 'bulk/operation/product',
                        'component' => 'BulkOperation',
                        'required' => ['file_path']
                    ],
                    'bulk/operation/itemcount' => [
                        'url' => 'bulk/operation/productcount',
                        'method' => 'getBulkItemCount',
                        'resource' => 'bulk/operation/productcount',
                        'component' => 'BulkOperation',
                        'required' => ['file_path']
                    ],
                    'bulk/operation/product' => [
                        'url' => 'bulk/operation/product',
                        'method' => 'getBulkItem',
                        'resource' => 'bulk/operation/product',
                        'component' => 'BulkOperation',
                        'response_class' => 'App\Shopifywebapi\Api\Response\BulkOperation\Product',
                        'required' => ['file_path']
                    ],
                    'bulk/operation/productcount' => [
                        'url' => 'bulk/operation/productcount',
                        'method' => 'getBulkItemCount',
                        'resource' => 'bulk/operation/productcount',
                        'component' => 'BulkOperation',
                        'response_class' => 'App\Shopifywebapi\Api\Response\BulkOperation\Product',
                        'required' => ['file_path']

                    ],
                    //vishal code starts here
                    'customer/count' => [
                        'url' => 'customer/count',
                        'method' => 'getCustomerCount',
                        'resource' => 'customer/count',
                        'component' => 'Customer',
                    ],
                    'customer' => [
                        'url' => 'customer',
                        'method' => 'getShopifyCustomers',
                        'resource' => 'customer/getShopifyCustomers',
                        'component' => 'Customer',
                    ],
                    'customer/searches' => [
                        'url' => 'customer/searches',
                        'method' => 'getShopifyCustomerGroups',
                        'resource' => 'customer/searches',
                        'component' => 'Customer',
                    ],
                    'customer/address' => [
                        'url' => 'customer/address',
                        'method' => 'getCustomerAddress',
                        'resource' => 'customer/address',
                        'component' => 'Customer',
                    ],
                    'customer/orders' => [
                        'url' => 'customer/orders',
                        'method' => 'getAllOrdersPlacedByCustomer',
                        'resource' => 'customer/orders',
                        'component' => 'Customer',
                    ],
                    'order' => [
                        'url' => 'order',
                        'method' => 'get',
                        'resource' => 'order',
                        'component' => 'Order',
                    ],
                    'order/count' => [
                        'url' => 'order/count',
                        'method' => 'getOrderCount',
                        'resource' => 'order/count',
                        'component' => 'Order',
                    ],
                    'get/fulfillmentOrder' => [
                        'url' => 'get/fulfillmentOrder',
                        'method' => 'fulfillmentOrder',
                        'resource' => 'get/fulfillmentOrder',
                        'component'=> 'Order'
                    ],
                    'get/ordershipment' => [
                        'url' => 'get/ordershipment',
                        'method' => 'getordershipment',
                        'resource' => 'get/ordershipment',
                        'component' => 'Order'
                    ],
                    'abandoned/checkouts' => [
                        'url' => 'abandoned/checkouts',
                        'method' => 'get',
                        'resource' => 'abandoned/checkouts',
                        'component' => 'Checkout',
                    ],
                    'abandoned/checkouts/count' => [
                        'url' => 'abandoned/checkouts/count',
                        'method' => 'getcount',
                        'resource' => 'abandoned/checkouts/count',
                        'component' => 'Checkout',

                    ],
                    'collection' => [
                        'url' => 'collection',
                        'method' => 'get',
                        'resource' => 'collection/get',
                        'component' => 'Collection',
                        'required' => ['collection_type']
                    ],
                    'collection/count' => [
                        'url' => 'collection/count',
                        'method' => 'getCollectionCount',
                        'resource' => 'collection/count',
                        'component' => 'Collection',
                        'required' => ['collection_type']
                    ],
                    // 'saleschannel/product'=> [
                    //     'url' => 'saleschannel/product',
                    //     'method' => 'getProductListing',
                    //     'resource' => 'saleschannel/getproductlisting',
                    //     'component'=> 'SalesChannel'
                    // ],
                    'saleschannel/product/product_ids' => [
                        'url' => 'saleschannel/product/product_ids',
                        'method' => 'getListingProductIds',
                        'resource' => 'saleschannel/product/getproductlistingids',
                        'component' => 'SalesChannel'
                    ],
                    // 'saleschannel/product/count'=> [
                    //     'url' => 'saleschannel/product/count',
                    //     'method' => 'getProductListingCount',
                    //     'resource' => 'saleschannel/product/getproductlistingcount',
                    //     'component'=> 'SalesChannel'
                    // ],
                    'saleschannel/collection' => [
                        'url' => 'saleschannel/collection',
                        'method' => 'getCollectionListing',
                        'resource' => 'saleschannel/getcollectionlisting',
                        'component' => 'SalesChannel'
                    ],
                    'saleschannel/collection/product_ids' => [
                        'url' => 'saleschannel/collection/product_ids',
                        'method' => 'getCollectionProductIds',
                        'resource' => 'saleschannel/getcollectionproductids',
                        'component' => 'SalesChannel',
                        'required' => ['id']
                    ],
                    'saleschannel/resource_feedback' => [
                        'url' => 'saleschannel/resource_feedback',
                        'method' => 'getResourceFeedback',
                        'resource' => 'saleschannel/getresourcefeedback',
                        'component' => 'SalesChannel'
                    ],
                    'saleschannel/product_resource_feedback' => [
                        'url' => 'saleschannel/product_resource_feedback',
                        'method' => 'getProductResourceFeedback',
                        'resource' => 'saleschannel/getproductresourcefeedback',
                        'component' => 'SalesChannel',
                        'required' => ['product_id']
                        ],
                        'collection' => [
                            'url' => 'collection',
                            'method' => 'get',
                            'resource' => 'collection/get',
                            'component'=> 'Collection',
                            'required'=> ['collection_type']
                        ],
                        'collection/count'=> [
                            'url' => 'collection/count',
                            'method' => 'getCollectionCount',
                            'resource' => 'collection/count',
                            'component'=> 'Collection',
                            'required'=> ['collection_type']
                        ],
                        'getAllCollections' => [
                            'url' => 'getAllCollections',
                            'method' => 'getAllCollections',
                            'resource' => 'collection/getAllCollections',
                            'component' => 'Collection',
                            'required' => ['product_id']
                        ],
                        // 'saleschannel/product'=> [
                        //     'url' => 'saleschannel/product',
                        //     'method' => 'getProductListing',
                        //     'resource' => 'saleschannel/getproductlisting',
                        //     'component'=> 'SalesChannel'
                        // ],
                        'saleschannel/product/product_ids'=> [
                            'url' => 'saleschannel/product/product_ids',
                            'method' => 'getListingProductIds',
                            'resource' => 'saleschannel/product/getproductlistingids',
                            'component'=> 'SalesChannel'
                        ],
                        // 'saleschannel/product/count'=> [
                        //     'url' => 'saleschannel/product/count',
                        //     'method' => 'getProductListingCount',
                        //     'resource' => 'saleschannel/product/getproductlistingcount',
                        //     'component'=> 'SalesChannel'
                        // ],
                        'saleschannel/collection'=> [
                            'url' => 'saleschannel/collection',
                            'method' => 'getCollectionListing',
                            'resource' => 'saleschannel/getcollectionlisting',
                            'component'=> 'SalesChannel'
                        ],
                        'saleschannel/collection/product_ids'=> [
                            'url' => 'saleschannel/collection/product_ids',
                            'method' => 'getCollectionProductIds',
                            'resource' => 'saleschannel/getcollectionproductids',
                            'component'=> 'SalesChannel',
                            'required' => ['id']
                        ],
                        'saleschannel/resource_feedback'=> [
                            'url' => 'saleschannel/resource_feedback',
                            'method' => 'getResourceFeedback',
                            'resource' => 'saleschannel/getresourcefeedback',
                            'component'=> 'SalesChannel'
                        ],
                        'saleschannel/product_resource_feedback'=> [
                            'url' => 'saleschannel/product_resource_feedback',
                            'method' => 'getProductResourceFeedback',
                            'resource' => 'saleschannel/getproductresourcefeedback',
                            'component'=> 'SalesChannel',
                            'required' => ['product_id']

                    ],
                    'webhook/webhook_config' => [
                        'url' => 'webhook/webhook_config',
                        'method' => 'getWebhookConfig',
                        'resource' => 'webhook/webhook_config',
                        'component' => 'Webhook',
                    ],
                    'ping' => [
                        'url' => 'ping',
                        'method' => 'ping',
                        'resource' => 'shop/ping',
                        'component' => 'Shop'
                    ],
                    'get_order' =>[	
                        'url' => 'get_order',	
                        'method' => 'getOrders',	
                        'resource' => 'Fulfillment/getOrders',	
                        'component' => 'Fulfillment'	
                    ],
                    'assigned_fulfillment_services' =>[	
                        'url' => 'assigned_fulfillment_services',	
                        'method' => 'assignedFulfillments',	
                        'resource' => 'Fulfillment/assignedFulfillments',	
                        'component' => 'Fulfillment',	
                    ],
                    'assigned_fulfillment' => [
                        'url' => 'assigned_fulfillment',
                        'method' => 'assignedFulfillmentOrder',
                        'resource' => 'Fulfillment/assignedFulfillmentOrder',
                        'component' => 'Fulfillment',
                    ],
                    'getFulfillment_services' => [
                        'url' => 'getFulfillment_services',
                        'method' => 'getFulfillmentServices',
                        'resource' => 'Fulfillment/getFulfillmentServices',
                        'component' => 'Fulfillment',
                    ],
                    // 'hmacvalidate' => [
                    //     'url' => 'hmacvalidate',
                    //     'method' => 'hmacValidate',
                    //     'resource' => 'shop/hmacvalidate',
                    //     'component'=> 'Shop'
                    // ]
                    'files/getFileUrlUsingId' => [
                        'url' => 'files/getFileUrlUsingId',
                        'method' => 'getFileUrlUsingId',
                        'resource' => 'files/getFileUrlUsingId',
                        'component' => 'Files',
                    ],
                    'shipping_zones' => [
                        'url' => 'shipping_zones',
                        'method' => 'get',
                        'resource' => 'shop/get',
                        'component' => 'Shop'
                    ],
                    'variants/count' => [
                        'url' => 'variants/count',
                        'method' => 'getProductWithVariantCount',
                        'resource' => 'variants/count',
                        'component' => 'Product',
                    ],
                ],
            ],
            'POST' => [
                'routes' => [
                    'webhook' => [
                        'url' => 'webhook',
                        'method' => 'create',
                        'resource' => 'webhook/create',
                        'component' => 'Webhook',
                    ],
                    'fulfillment_services' => [
                        'url' => 'fulfillment_services',
                        'method' => 'createFulfillment',
                        'resource' => 'Fulfillment/createFulfillment',
                        'component' => 'Fulfillment',
                    ],
                    'webhook/register' => [
                        'url' => 'webhook/register',
                        'method' => 'register',
                        'resource' => 'webhook/register',
                        'component' => 'Webhook',
                    ],
                    'billing/recurring' => [
                        'url' => 'billing/recurring',
                        'method' => 'create',
                        'resource' => 'billing/recurring',
                        // 'component'=> 'Billing',
                        'class' => 'App\Shopifywebapi\Api\Billing\Recurring',
                        'response_class' => 'App\Shopifywebapi\Api\Response\Billing\Recurring'
                    ],
                    'usageCharge' => [
                        'url' => 'usageCharge',
                        'method' => 'create',
                        'resource' => 'usageCharge',
                        // 'component'=> 'Billing',
                        'class' => 'App\Shopifywebapi\Api\Billing\UsageCharge',
                        //                            'response_class' => 'App\Shopifywebapi\Api\Response\Billing\Recurring'
                    ],
                    'billing/recurring/activate' => [
                        'url' => 'billing/recurring/activate',
                        'method' => 'activate',
                        'resource' => 'billing/recurring',
                        // 'component'=> 'Billing',
                        'class' => 'App\Shopifywebapi\Api\Billing\Recurring',
                        'response_class' => 'App\Shopifywebapi\Api\Response\Billing\Recurring',
                        'required' => ['id']
                    ],
                    'billing/onetime' => [
                        'url' => 'billing/onetime',
                        'method' => 'create',
                        'resource' => 'billing\onetime',
                        // 'component'=> 'Billing',
                        'class' => 'App\Shopifywebapi\Api\Billing\OneTime',
                        'response_class' => 'App\Shopifywebapi\Api\Response\Billing\OneTime',
                    ],
                    'billing/onetime/activate' => [
                        'url' => 'billing/onetime/activate',
                        'method' => 'activate',
                        'resource' => 'billing/onetime',
                        // 'component'=> 'Billing',
                        'class' => 'App\Shopifywebapi\Api\Billing\OneTime',
                        'response_class' => 'App\Shopifywebapi\Api\Response\Billing\OneTime',
                        'required' => ['id']
                    ],
                    'bulk/operation' => [
                        'url' => 'bulk/operation',
                        'method' => 'createBulkOperation',
                        'resource' => 'bulk/operation',
                        'component' => 'BulkOperation',
                        'required' => ['type']
                    ],
                    'webhook/webhook_config' => [
                        'url' => 'webhook/webhook_config',
                        'method' => 'getWebhookConfig',
                        'resource' => 'webhook/webhook_config',
                        'component' => 'Webhook',
                    ],
                    'ping' => [
                        'url' => 'ping',
                        'method' => 'ping',
                        'resource' => 'shop/ping',
                        'component' => 'Shop'
                    ],
                    'shop/access_scopes' => [
                        'url' => 'shop/access_scopes',
                        'method' => 'checkMissingAccessScopes',
                        'resource' => 'shop/access_scopes',
                        'component' => 'Shop'
                    ],

                    'cancelfulfillment' => [
                        'url' => 'cancelfulfillment',
                        'method' => 'cancelFulfillment',
                        'resource' => 'Fulfillment/cancelFulfillment',
                        'component' => 'Fulfillment',
                    ],
                    'rejectfulfillment' => [
                        'url' => 'rejectfulfillment',
                        'method' => 'rejectFulfillmentOrder',
                        'resource' => 'Fulfillment/rejectFulfillmentOrder',
                        'component' => 'Fulfillment',
                    ],
                    'acceptfulfillmentrequest' => [
                        'url' => 'acceptfulfillmentrequest',
                        'method' => 'acceptingFulfillmentRequest',
                        'resource' => 'Fulfillment/acceptingFulfillmentRequest',
                        'component' => 'Fulfillment',
                    ],
                    'acceptcancellationfulfillmentrequest' => [
                        'url' => 'acceptcancellationfulfillmentrequest',
                        'method' => 'acceptCancellationRequest',
                        'resource' => 'Fulfillment/acceptCancellationRequest',
                        'component' => 'Fulfillment',
                    ],
                    'rejectcancellationfulfillmentrequest' => [
                        'url' => 'rejectcancellationfulfillmentrequest',
                        'method' => 'rejectCancellationRequest',
                        'resource' => 'Fulfillment/rejectCancellationRequest',
                        'component' => 'Fulfillment',
                    ],
                    'closefulfillmentorders' => [
                        'url' => 'closefulfillmentorders',
                        'method' => 'closeFulfillmentOrder',
                        'resource' => 'Fulfillment/closeFulfillmentOrder',
                        'component' => 'Fulfillment',
                    ],
                    'shopifygql/query' => [
                        'url' => 'shopifygql/query',
                        'method' => 'query',
                        'resource' => 'shopifygql/query',
                        'component' => 'ShopifyGQL'
                    ],
                    'shopifygql/mutation' => [
                        'url' => 'shopifygql/mutation',
                        'method' => 'mutation',
                        'resource' => 'shopifygql/mutation',
                        'component' => 'ShopifyGQL'
                    ],
                    'saleschannel/product' => [
                        'url' => 'saleschannel/product',
                        'method' => 'createProductListing',
                        'resource' => 'saleschannel/createproductlisting',
                        'component' => 'SalesChannel'
                    ],
                    'saleschannel/collection' => [
                        'url' => 'saleschannel/collection',
                        'method' => 'createCollectionListing',
                        'resource' => 'saleschannel/createcollectionlisting',
                        'component' => 'SalesChannel'
                    ],
                    'saleschannel/resource_feedback' => [
                        'url' => 'saleschannel/resource_feedback',
                        'method' => 'createResourceFeedback',
                        'resource' => 'saleschannel/createresourcefeedback',
                        'component' => 'SalesChannel'
                    ],
                    'saleschannel/product_resource_feedback' => [
                        'url' => 'saleschannel/product_resource_feedback',
                        'method' => 'createProductResourceFeedback',
                        'resource' => 'saleschannel/createproductresourcefeedback',
                        'component' => 'SalesChannel',
                        'required' => ['product_id']
                    ],
                    'order/cancel' => [
                        'url' => 'order/cancel',
                        'method' => 'orderCancel',
                        'resource' => 'order/orderCancel',
                        'component' => 'Order',
                        'required' => ['order_id']
                    ],
                    'order/fulfillmentCreate' => [
                        'url' => 'order/fulfillmentCreate',
                        'method' => 'fulfillOrder',
                        'resource' => 'order/fulfillOrder',
                        'component' => 'Order',
                    ],
                    'shop/addscript' => [
                        'url' => 'shop/addscript',
                        'method' => 'addScript',
                        'resource' => 'shop/addScript',
                        'component' => 'Shop',
                        'required' => ['script_url']
                    ],
                    'files/commenceStagedUploadsCreate' => [
                        'url' => 'files/commenceStagedUploadsCreate',
                        'method' => 'commenceStagedUploadsCreate',
                        'resource' => 'files/commenceStagedUploadsCreate',
                        'component' => 'Files'
                    ],
                    'files/stagedUploadsCreate' => [
                        'url' => 'files/stagedUploadsCreate',
                        'method' => 'stagedUploadsCreate',
                        'resource' => 'files/stagedUploadsCreate',
                        'component' => 'Files'
                    ],
                    'files/createFileOnShopify' => [
                        'url' => 'files/createFileOnShopify',
                        'method' => 'createFileOnShopify',
                        'resource' => 'files/createFileOnShopify',
                        'component' => 'Files'
                    ],
                    'accept_fulfillment_order' => [
                        'url' => 'accept_fulfillment_order',
                        'method' => 'acceptFulfillmentOrder',
                        'resource' => 'Fulfillment/acceptFulfillmentOrder',
                        'component' => 'Fulfillment',
                    ],
                    'cancell_fulfillment_order' => [
                        'url' => 'cancell_fulfillment_order',
                        'method' => 'cancellFulfillmentOrder',
                        'resource' => 'Fulfillment/cancellFulfillmentOrder',
                        'component' => 'Fulfillment',
                    ],
                    'updateTrackingDetails'=>[
                        'url' => 'updateTracking',
                        'method' => 'updateTracking',
                        'resource' => 'Fulfillment/updateTracking',
                        'component' => 'Fulfillment'
                    ],
                    'reject_fulfillment_order' => [	
                        'url' => 'reject_fulfillment_order',	
                        'method' => 'rejectingFulfillmentRequest',	
                        'resource' => 'Fulfillment/rejectingFulfillmentRequest',	
                        'component' => 'Fulfillment',	
                    ],
                    'inventory_levels/set' => [
                        'url' => 'inventory_levels/set',
                        'method' => 'setInventoryLevels',
                        'resource' => 'inventory/setInventoryLevels',
                        'component' => 'Inventory',
                    ],
                    'fulfillments' => [
                        'url' => 'fulfillments',
                        'method' => 'createfulfillments',
                        'resource' => 'Fulfillment/createfulfillments',
                        'component' => 'Fulfillment',
                    ],
                    'inventory_levels/connect' => [
                        'url' => 'inventory_levels/connect',
                        'method' => 'connectInventoryLevels',
                        'resource' => 'inventory/connectInventoryLevels',
                        'component' => 'Inventory',
                    ],
                    'billing/credit' => [
                        'url' => 'billing/credit',
                        'method' => 'createApplicationCredits',
                        'resource' => 'credit/createApplicationCredits',
                        'component' => 'Billing\Credit',
                    ],
                    'fulfillment_orders/cancel' => [
                        'url' => 'fulfillment_orders/cancel',
                        'method' => 'fulfillmentOrdersCancel',
                        'resource' => 'Fulfillment/fulfillmentOrdersCancel',
                        'component' => 'Fulfillment',
                    ]
                ],
            ],
            'PUT' => [
                'routes' => [
                    'webhook' => [
                        'url' => 'webhook',
                        'method' => 'update',
                        'resource' => 'webhook/update',
                        'component' => 'Webhook',
                    ],
                    'billing/recurring' => [
                        'url' => 'billing/recurring',
                        'method' => 'update',
                        'resource' => 'billing/recurring',
                        // 'component'=> 'Billing',
                        'class' => 'App\Shopifywebapi\Api\Billing\Recurring',
                        'response_class' => 'App\Shopifywebapi\Api\Response\Billing\Recurring',
                        'required' => ['id', 'capped_amount']
                    ],
                    'orders' => [
                        'url' => 'orders',
                        'method' => 'update',
                        'resource' => 'order',
                        'component' => 'Order'
                    ]
                ],
            ],
            'DELETE' => [
                'routes' => [
                    'shop/deletescript' => [
                        'url' => 'shop/deletescript',
                        'method' => 'deleteScript',
                        'resource' => 'shop/deleteScript',
                        'component' => 'Shop',
                        'required' => ['id']
                    ],
                    'webhook' => [
                        'url' => 'webhook',
                        'method' => 'delete',
                        'resource' => 'webhook/delete',
                        'component' => 'Webhook',
                    ],
                    'billing/recurring' => [
                        'url' => 'billing/recurring',
                        'method' => 'delete',
                        'resource' => 'billing/recurring',
                        // 'component'=> 'Billing',
                        'class' => 'App\Shopifywebapi\Api\Billing\Recurring',
                        'required' => ['id']
                    ],
                    'webhook/unregister' => [
                        'url' => 'webhook/unregister',
                        'method' => 'unregister',
                        'resource' => 'webhook/unregister',
                        'component' => 'Webhook',
                    ],
                    'bulk/operation' => [
                        'url' => 'bulk/operation',
                        'method' => 'cancelBulkOperation',
                        'resource' => 'bulk/operation',
                        'component' => 'BulkOperation',
                        'required' => ['id']
                    ],
                    'saleschannel/product' => [
                        'url' => 'saleschannel/product',
                        'method' => 'deleteProductListing',
                        'resource' => 'saleschannel/deleteproductlisting',
                        'component' => 'SalesChannel',
                        'required' => ['id']
                    ],
                    'saleschannel/collection' => [
                        'url' => 'saleschannel/collection',
                        'method' => 'deleteCollectionListing',
                        'resource' => 'saleschannel/deletecollectionlisting',
                        'component' => 'SalesChannel',
                        'required' => ['id']
                    ],
                    'app/remove' => [
                        'url' => 'app/remove',
                        'method' => 'appUninstall',
                        'resource' => 'app/remove',
                        'component'=> 'Shop'
                    ],
                    'fulfillment_services' => [
                        'url' => 'fulfillment_services',
                        'method' => 'deleteFulfillmentServices',
                        'resource' => 'Fulfillment/deleteFulfillmentServices',
                        'component' => 'Fulfillment',
                    ]
                ],
            ],
        ],
    ],
    'marketplace-modules' => [
        'ebay' => 'Ebaywebapi',
        'shopify' => 'Shopifywebapi'
    ]
];