<?php

namespace App\Shopifywebapi\Controllers;

class AuthController extends \App\Core\Controllers\BaseController
{
    /**
     * installAction Opens up a form to connect with shopify and twitter
     * @return void
     */
    public function installAction()
    {
        $state = $this->request->get('state') ?? '';
        $sAppId = $this->request->get('sAppId') ?? '';
        $appType = $this->request->get('appType') ?? '';
        $appCode = $this->request->get('appCode') ?? '';
        $decodedState = json_decode(base64_decode($state), true) ?: (json_decode($state, true) ?? []);
        
        if ($this->request->isGet() && !empty($decodedState['clientId'])
            && !empty($decodedState['clientSecret'])
            && !empty($decodedState['shop'])
            && !empty($decodedState['accessToken'])
        ) {
            $authUrl = $this->di->getConfig()->get('backend_base_url') . 'apiconnect/request/commenceAuth/?';
            $decodedState['sAppId'] = $sAppId;
            $decodedState['appCode'] = $appCode;
            $decodedState['state'] = $state;
            $decodedState['appType'] = $appType;
            unset($decodedState['user_id'], $decodedState['marketplace']);
            $authUrl .= http_build_query($decodedState);
            return $this->response->redirect($authUrl);
        }
      
        if ($this->request->isPost()) {
            $postData = $this->request->getPost(); // clientId, clientSecret, shopUrl, accessToken, sAppId, appCode
            $postData['shop'] = preg_replace('/^https?:\/\/+/', '', $postData['shop']); // remove http:// or https:// from beginning of shopUrl
            $postData['shop'] = ltrim($postData['shop'], '/'); // remove trailing slashes from start of shopUrl
            $postData['shop'] = rtrim($postData['shop'], '/'); // remove trailing slashes from end of shopUrl
            $postData = array_map('trim', $postData);
            $authUrl = $this->di->getConfig()->get('backend_base_url') . 'apiconnect/request/commenceAuth/?';
            $authUrl .= http_build_query($postData);
            return $this->response->redirect($authUrl);
        }

        $appConfig = $this->di->getRegistry()->getAppConfig();
        $scopes = explode(',', $appConfig['live']['scope']);
        // Get query parameters from the frontend
        /*$sAppId = $this->request->get('sAppId') ?? '';
        $appType = $this->request->get('appType') ?? '';
        $appCode = $this->request->get('appCode') ?? ''; */

        if (!empty($sAppId) && !empty($appType) && !empty($appCode) && !empty($state)) {
            $this->view->appCode = $appCode;
            $this->view->sAppId = $sAppId;
            $this->view->appType = $appType;
            $this->view->state = $state;
            $this->view->scopes = $scopes;

            $decodedState = json_decode($state, true);
            if (isset($decodedState['shopUrl'])) {
                $this->view->shopUrl = $decodedState['shopUrl'];
            }
        } else {
            return [
                'success' => false,
                'error' => 'sAppId or appType or appCode not set'
            ];
        }
    }

    public function validateHmacAction()
    {
        $contentType = $this->request->getHeader('Content-Type');
        if (strpos($contentType, 'application/json') !== false) {
            $rawBody = $this->request->getJsonRawBody(true);
        } else {
            $rawBody = $this->request->get();
        }

        $response = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Helper')->validateHmac($rawBody);

        return $this->prepareResponse($response);
    }
}
