<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Webhook;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class WebhookQL extends Common
{
	public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getWebhook($filter=[])
    {
    	if(isset($filter['id'])) {
            $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\QueryQL')->getSingleWebhookQuery();
        }
        else {
	    	$query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\QueryQL')->getWebhooksQuery();
		}

		$data = $this->init()->graph($query);
		var_dump($data['body']);die;
		return $data['body'];
    }

    public function createWebhook($data)
    {
        $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\QueryQL')->getCreateWebhookMutation();

		$data = $this->init()->graph($query);
		var_dump($data['body']);die;
		return $data['body'];
    }

    public function updateWebhook($data)
    {
        $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\QueryQL')->getUpdateWebhookMutation();

		$data = $this->init()->graph($query);
		var_dump($data['body']);die;
		return $data['body'];
    }

    public function deleteWebhook($data)
    {
        $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\QueryQL')->getDeleteWebhookMutation();

		$data = $this->init()->graph($query);
		var_dump($data['body']);die;
		return $data['body'];
    }
}