<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Webhook;

use Exception;
use Aws\Sqs\SqsClient;
use Aws\Exception\AwsException;
use App\Shopifywebapi\Components\Core\Common;

class Sqs extends Common
{
    private $_data = null;

    private $_sqsClient = null;

    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function createQueue($data)
    {
        $this->_data = $data;

        // $validate = $this->validatePostData();
        // if($validate['status'])
        // {
            try {
                $queueUrl = $this->getQueueUrl();

                if($queueUrl === false) {
                    $result = $this->getClient()->createQueue([
                        'QueueName'  => $data['queue_name'],
                        'Attributes' => [
                            'DelaySeconds'       => 0,
                            'MaximumMessageSize' => 200000, // 4 KB
                            'VisibilityTimeout' => 2 * 60, // 2 min max time to process the message
                        ]
                    ]);

                    $queueUrl = $result->get('QueueUrl');
                }

                if($queueUrl)
                {
                    // return $this->saveSqsConfig($request_data, $queueUrl);
                    return [
                        'success'   => true,
                        'queue_url'  => $queueUrl
                    ];
                }
                else
                {
                    return [
                       'success'    => false,
                       'msg'        => 'something went wrong in sqs'
                    ];
                }
            } catch (AwsException $e){
                return [
                   'success'    => false,
                   'msg'        => 'Sqs credentials are not valid',
                   'error'      => $e->getAwsErrorMessage()
                ];
            } catch (Exception $e){
                return [
                    'success'   => false,
                    'msg'       => 'Sqs credentials are not valid',
                    'error'     => $e->getMessage()
                ];
            }
        // }
        // else
        // {
        //     return [
        //         'success'   => false,
        //         'msg'       => $validate['error']
        //     ];
        // }
    }

    public function getQueueUrl()
    {
        $data = $this->_data;

        $queueName = $data['queue_name'];

        $result = $this->getClient($data)->listQueues(array(
            'QueueNamePrefix' => $queueName
        ));

        $queueUrl = false;
        if ($queues = $result->getPath('QueueUrls')) {
            $queueUrl = $queues[0];
        }
        return $queueUrl;
    }

    public function getClient()
    {
        $data = $this->_data;

        if(is_null($this->_sqsClient))
        {
            $config = [
                'version'     => 'latest',
                'region'      => $data['queue_config']['region'],
                'credentials' => [
                    'key'    => $data['queue_config']['key'],
                    'secret' => $data['queue_config']['secret']
                ]
            ];

            $this->_sqsClient = new SqsClient($config);
        }

        return $this->_sqsClient;
    }
}
