<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Webhook;

use rdx\graphqlquery\Query as phpGraphQueryBuilder;

class QueryQL
{
    /**
     * Modifying query here doesn't reflect on live, kindly note this query output is being cached
     * So plz fluch cache once made changes here
     * @return string
     */
    public function getWebhooksQuery()
    {
        /*query {
            webhookSubscriptions(first:250) {
                edges {
                    node(id)
                }
            }
        }*/

        $query = phpGraphQueryBuilder::query('', []);
        $query->fields('webhookSubscriptions');
        $query->webhookSubscriptions->attribute('first' , 250);
        $query->webhookSubscriptions->fields('edges');
        $query->webhookSubscriptions->edges->fields('node');
        $query->webhookSubscriptions->edges->node->fields('id', 'topic', 'callbackUrl');
        return $query->build();
    }

    public function getSingleWebhookQuery()
    {
        /*query {
            webhookSubscription(id:) {
                topic,callbackUrl,createdAt
            }
        }*/

        $query = phpGraphQueryBuilder::query('', []);
        $query->fields('webhookSubscription');
        $query->webhookSubscription->attribute('id' , 'gid://shopify/WebhookSubscription/766410915976');
        $query->webhookSubscription->fields('id', 'topic', 'callbackUrl', 'createdAt');
        return $query->build();
    }

    /**
     * Modifying query here doesn't reflect on live, kindly note this query output is being cached
     * So plz fluch cache once made changes here
     * @return string
     */
    public function getCreateWebhookMutation()
    {
        /*'mutation webhookSubscriptionCreate($topic: WebhookSubscriptionTopic!, $webhookSubscription: WebhookSubscriptionInput!) {
          webhookSubscriptionCreate(topic: $topic, webhookSubscription: $webhookSubscription) {
            userErrors {
              field
              message
            }
            webhookSubscription {
              id
            }
          }
        }';*/
        $mutation = phpGraphQueryBuilder::mutation('', []);
        $mutation->field('webhookSubscriptionCreate');
        $mutation->webhookSubscriptionCreate->attribute('topic' , phpGraphQueryBuilder::enum('ORDERS_CREATE'));
        // $mutation->webhookSubscriptionCreate->attribute('webhookSubscription' , ['callbackUrl' => 'https://whatever.hostname.com/product/create', 'format' => phpGraphQueryBuilder::enum('JSON')]);
        $mutation->webhookSubscriptionCreate->attribute('webhookSubscription' , ['callbackUrl' => 'https://whatever.hostname.com/product/create']);
        $mutation->webhookSubscriptionCreate->field('userErrors');
        $mutation->webhookSubscriptionCreate->userErrors->field('field');
        $mutation->webhookSubscriptionCreate->userErrors->field('message');
        $mutation->webhookSubscriptionCreate->field('webhookSubscription');
        $mutation->webhookSubscriptionCreate->webhookSubscription->field('id');
        return $mutation->build();
    }

    /**
     * Modifying query here doesn't reflect on live, kindly note this query output is being cached
     * So plz fluch cache once made changes here
     * @return string
     */
    public function getUpdateWebhookMutation()
    {
        /*mutation webhookSubscriptionUpdate($id: ID!, $webhookSubscription: WebhookSubscriptionInput!) {
          webhookSubscriptionUpdate(id: $id, webhookSubscription: $webhookSubscription) {
            userErrors {
              field
              message
            }
            webhookSubscription {
              id
            }
          }
        }*/
        $mutation = phpGraphQueryBuilder::mutation('', []);
        $mutation->field('webhookSubscriptionUpdate');
        $mutation->webhookSubscriptionUpdate->attribute('id', 'gid://shopify/WebhookSubscription/766410915976');
        $mutation->webhookSubscriptionUpdate->attribute('webhookSubscription' , ['callbackUrl' => 'https://update-whatever.hostname.com/order/create']);
        $mutation->webhookSubscriptionUpdate->field('userErrors');
        $mutation->webhookSubscriptionUpdate->userErrors->field('field');
        $mutation->webhookSubscriptionUpdate->userErrors->field('message');
        $mutation->webhookSubscriptionUpdate->field('webhookSubscription');
        $mutation->webhookSubscriptionUpdate->webhookSubscription->field('id');
        return $mutation->build();
    }

    /**
     * Modifying query here doesn't reflect on live, kindly note this query output is being cached
     * So plz fluch cache once made changes here
     * @return string
     */
    public function getDeleteWebhookMutation()
    {
        /*mutation webhookSubscriptionDelete($id: ID!) {
          webhookSubscriptionDelete(id: $id) {
            deletedWebhookSubscriptionId
            userErrors {
              field
              message
            }
          }
        }*/
        $mutation = phpGraphQueryBuilder::mutation('', []);
        $mutation->field('webhookSubscriptionDelete');
        $mutation->webhookSubscriptionDelete->attribute('id', 'gid://shopify/WebhookSubscription/766410915976');
        $mutation->webhookSubscriptionDelete->field('deletedWebhookSubscriptionId');
        $mutation->webhookSubscriptionDelete->field('userErrors');
        $mutation->webhookSubscriptionDelete->userErrors->field('field');
        $mutation->webhookSubscriptionDelete->userErrors->field('message');
        return $mutation->build();
    }
}