<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\ShopifyGQL;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class ShopifyGQL extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function executeQuery($query)
    {
        $data = $this->init()->graph($query);
        $res = $this->shapeResponse($data);

        return $res;
    }

    public function executeMutation($mutation)
    {
        $data = $this->init()->graph($mutation);
        $res = $this->shapeResponse($data);

        return $res;
    }

    public function shapeResponse($response)
    {
        // todo : check the error logging flag where config value will be checked for error logging rather passing non-relavent message  to frontend
        if (isset($response['errorFlag'])) {
            return $response;
        } else if (!empty($response['errors'])) {
            $msg = "";
            if (is_array($response['body'])) {
                foreach ($response['body'] as $error) {
                    if (empty($msg)) {
                        $msg = $error['message'];
                        continue;
                    }
                    $msg = $msg . ' , ' . $error['message'];
                }
            } elseif (is_string($response['body'])) {
                return [
                    'success' => false,
                    'message' => $response['body']
                ];
            }
            return [
                'success' => false,
                'message' => $msg
            ];
        } else if (isset($response['body']['eventBridgeWebhookSubscriptionCreate'])) {
            $webhookSubscriptionData = $response['body']['eventBridgeWebhookSubscriptionCreate'];
            if (!empty($webhookSubscriptionData['userErrors'])) {
                $message = $webhookSubscriptionData['userErrors'][0]['message'] ?? 'Something Went Wrong';
                return [
                    'success' => false,
                    'message' => $message
                ];
            }
            if (!empty($webhookSubscriptionData['webhookSubscription'])) {
                $response['body']=$webhookSubscriptionData['webhookSubscription'];
            }
        }
        return [
            'success' => true,
            'data' => $response['body']
        ];
    }
}
