<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Shop;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class ShopQL extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    /**
     * @return array
     * check here
     */
    /*public function pullShopInfoandSave()
    {
        $sellerShopDetail = $this->getShopDetail();
        // save seller data into database

        return $sellerShopDetail;
    }*/

    public function getShopDetail()
    {
        $shopQuery = $this->di->getCache()->get('shopifyShopQuery', 'shopify');

        if(!$shopQuery){
            $shopQuery = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Shop\QueryQL')->getShopQuery();
            $this->di->getCache()->set('shopifyShopQuery', $shopQuery, 'shopify');
        }
        $shopData = $this->init()->graph($shopQuery);
        return $this->shapeResponse($shopData);
    }

    public function getShopLocationDetail()
    {
        $shopQuery = $this->di->getCache()->get('shopifyShopLocationQuery');
        if(!$shopQuery){
            $shopQuery = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Shop\QueryQL')->getShopLocationQuery();
            $this->di->getCache()->set('shopifyShopLocationQuery', $shopQuery);
        }
        $shopData = $this->graph($shopQuery);
        return $this->shapeResponse($shopData);
    }

    public function shapeResponse($shopData)
    {
        // todo : check the error logging flag where config value will be checked for error logging rather passing non-relavent message  to frontend
        if(isset($shopData['errorFlag'])){
            return $shopData;
        }else if(!empty($shopData['errors'])) {
            $msg = "";
            if(is_array($shopData['body'])){
                foreach($shopData['body'] as $error)
                {
                    if(empty($msg)){$msg = $error['message'];continue;}
                    $msg = $msg.' , '. $error['message'];
                }
            } elseif (is_string($shopData['body'])){
                return [
                    'success' => false,
                    'message' => $shopData['body']
                ];
            }
            return [
                'success' => false,
                'message' => $msg
            ];
        }
        // header info
        //print_r($shopData['response']->getHeaders());die('sd');
        //print_r($shopData['body']);die('sd');
        return [
            'success' => true,
            'data' => $shopData['body']
        ];
    }
}