<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Shop;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class Shop extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getShopDetail()
    {
        $this->init(false);

        $response = $this->rest('GET', 'shop.json');

        return $this->formatRestResponse($response);
    }

    public function getFbApprovalStatus()
    {
        die('test 000 remote');
    }

    public function checkMissingAccessScopes()
    {
        $this->init(false);
        $sellerAuth = $this->di->getObjectManager()->get('App\Shopifywebapi\Components\Authenticate\Sellerauth');

        $configScopes = array_map('trim', explode(',', (string) $this->_scope));

        $data = $sellerAuth->getTokenScopes($this->_shop, $this->_accessToken, $configScopes);
        return $data;
    }
    public function addScript($requestData)
    {
        $this->init(false);
        $data = [
            'script_tag' => [
                'event' => 'onload',
                'src' => $requestData['script_url']
            ]
        ];
        $response = $this->rest('POST', 'script_tags.json', $data);
        return $this->formatRestResponse($response);
    }
    public function getScripts()
    {
        $this->init(false);

        $response = $this->rest('GET', 'script_tags.json');
        return $this->formatRestResponse($response);
    }
    public function deleteScript($data)
    {
        $this->init(false);

        $response = $this->rest('DELETE', 'script_tags/' . $data['id'] . '.json');
        return $this->formatRestResponse($response);
    }

    public function appUninstall()
    {
        $this->init(false);

        $response = $this->rest('DELETE', 'api_permissions/current.json');

        return $this->formatRestResponse($response);
    }
}