<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Shop;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class Location extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getLocations($location_id)
    {
        $this->init(false);
        
        if(!is_null($location_id)) {
            $response = $this->rest('GET', "locations/{$location_id}.json");
        }
        else {
            $response = $this->rest('GET', 'locations.json');
        }

        return $this->formatRestResponse($response);
    }

    public function getLocationInventory($filter = [])
    {
        $this->init(false);
        
        $location_id = $filter['id'];
        unset($filter['id']);

        $response = $this->rest('GET', "locations/{$location_id}/inventory_levels.json", $filter);
        
        return $this->formatRestResponse($response);
    }
}