<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\SalesChannel;

use App\Shopifywebapi\Components\Core\Common;

class SalesChannel extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    /*public function getProductListing($filter = [])
    {
        $this->init(false);

        if(isset($filter['id'])) {
            $response = $this->rest('GET', 'product_listings/'.$filter['id'].'.json');
        }
        else {
            if(isset($filter['prev']) || isset($filter['next'])) {
                $cursor = base64_decode($filter['prev']??$filter['next']);
                parse_str($cursor, $params);
            }
            else {
                // limit = default: 50, maximum: 1000
                $default_params = [
                    'limit'     => 250
                ];

                $params = array_merge($default_params, $filter);
            }

            $response = $this->rest('GET', 'product_listings.json', $params);   
        }

        return $this->formatRestResponse($response);
    }*/

    public function getListingProductIds($filter = [])
    {
        $this->init(false);

        if(isset($filter['prev']) || isset($filter['next'])) {
            $cursor = base64_decode($filter['prev']??$filter['next']);
            parse_str($cursor, $params);
        }
        else {
            // limit = default: 50, maximum: 1000
            $default_params = [
                'limit'     => 250
            ];

            $params = array_merge($default_params, $filter);
        }

        $response = $this->rest('GET', 'product_listings/product_ids.json', $params);

        return $this->formatRestResponse($response);
    }

    /*public function getProductListingCount()
    {
        $this->init(false);

        $response = $this->rest('GET', 'product_listings/count.json');

        return $this->formatRestResponse($response);
    }*/

    public function createProductListing($id, $data)
    {
        $this->init(false);

        $response = $this->rest('PUT', "product_listings/{$id}.json", $data);

        return $this->formatRestResponse($response);
    }

    public function deleteProductListing($id)
    {
        $this->init(false);

        $response = $this->rest('DELETE', "product_listings/{$id}.json");

        return $this->formatRestResponse($response);
    }

    public function getCollectionListing($filter = [])
    {
        $this->init(false);

        if(isset($filter['id'])) {
            $response = $this->rest('GET', 'collection_listings/'.$filter['id'].'.json');
        }
        else {
            if(isset($filter['prev']) || isset($filter['next'])) {
                $cursor = base64_decode($filter['prev']??$filter['next']);
                parse_str($cursor, $params);
            }
            else {
                // limit = default: 50, maximum: 1000
                $default_params = [
                    'limit'     => 250
                ];

                $params = array_merge($default_params, $filter);
            }

            $response = $this->rest('GET', 'collection_listings.json', $params);   
        }

        return $this->formatRestResponse($response);
    }

    public function getCollectionProductIds($collectionId, $filter = [])
    {
        $this->init(false);

        if(isset($filter['prev']) || isset($filter['next'])) {
            $cursor = base64_decode($filter['prev']??$filter['next']);
            parse_str($cursor, $params);
        }
        else {
            //limit = default: 50, maximum: 1000
            $default_params = [
                'limit'     => 250
            ];

            $params = array_merge($default_params, $filter);
        }

        $response = $this->rest('GET', "collection_listings/{$collectionId}/product_ids.json", $params);

        return $this->formatRestResponse($response);
    }

    public function createCollectionListing($id, $data)
    {
        $this->init(false);

        $response = $this->rest('PUT', "collection_listings/{$id}.json", $data);

        return $this->formatRestResponse($response);
    }

    public function deleteCollectionListing($id)
    {
        $this->init(false);

        $response = $this->rest('DELETE', "collection_listings/{$id}.json");

        return $this->formatRestResponse($response);
    }

    public function getResourceFeedback()
    {
        $this->init(false);

        $response = $this->rest('GET', 'resource_feedback.json', $filter);

        return $this->formatRestResponse($response);
    }

    public function createResourceFeedback($data)
    {
        $this->init(false);

        $response = $this->rest('POST', "resource_feedback.json", $data);

        return $this->formatRestResponse($response);
    }

    public function getProductResourceFeedback($productId)
    {
        $this->init(false);

        $response = $this->rest('GET', "products/{$productId}/resource_feedback.json", $filter);

        return $this->formatRestResponse($response);
    }

    public function createProductResourceFeedback($productId, $data)
    {
        $this->init(false);

        $response = $this->rest('POST', "products/{$productId}/resource_feedback.json", $data);

        return $this->formatRestResponse($response);
    }
}