<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifywebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Route;

class Handler extends \App\Apiconnect\Components\Authenticate\Common
{
    public function requestRedirectAuthUrl($postData)
    {
        $auth = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Authenticate\Sellerauth')->init(false)->fetchAuthenticationUrl($postData['shop']);
        return $auth;
    }

    public function processAuth()
    {
        $postData = $this->di->getRequest()->get();
        foreach($postData as $key=>$value)
        {
            if($key == 'bearer'){$temp['state'] = $value;continue;}
            $temp[$key] = $value;
        }
        unset($temp['_url']);
        if (isset($postData['appType']) && (
        (!empty($postData['state'])
            || (!empty($postData['accessToken'])
            && !empty($postData['clientSecret'])
            && !empty($postData['clientId'])
            )
        )
            && $postData['appType'] == 'private'
        ))
        {
            $tokenInfo =  $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Authenticate\Sellerauth')->init(true, ['call_name' => 'authURL'])->verifyUserDetails($temp);
            if ($tokenInfo['success'] && isset($temp['state'])) {
                $this->di->getSession()->set("requested_state", $temp['state']);
                $shopDetails = [
                    'shop_url' => $temp['shop'],
                    'client_id' => $temp['clientId'],
                    'client_secret' => $temp['clientSecret'],
                    'shopify_app_id' => $temp['shopify_app_id'],
                    'is_private'=>true
                ];
            }
        } else {
            $tokenInfo = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Authenticate\Sellerauth')->init(false, ['call_name' => 'fetchToken'])->verifyRequestandFetchToken($temp);
            $shopDetails = [
                'shop_url' => $temp['shop'],
            ];
        }
        $appConfig = $this->di->getRegistry()->getAppConfig();
        $subAppId = $appConfig['sub_app_id'] ?? false;
        //$tokenInfo['state'] = $postData['state'];
        if($tokenInfo['success']) {
            $shopDetails['token'] = $tokenInfo['token'];
            $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop($shopDetails, ['shop_url']);
            if($shop['success']) $tokenInfo['data'] = $shop['data'];
            else return ['success' => false , 'message' => $shop['message']];
        }
        // $tokenInfo['data']['app_code'] = $appConfig['app_code'];
        return $tokenInfo;
    }

    public function prepareShopInfo(array $postData, array $sellerAuthToken)
    {
        $shopifyEndPoint =  "rest/v1/shop";
        $this->di->getObjectManager()->get('\App\Connector\Components\ApiClient')->call($shopifyEndPoint, [], ['AppId' => $this->di->getConfig()->get('shopify-app-id')]);
    }

    public function isSellerEligible($url, $data)
    {

        $shopExists = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->getShop(false, false, ['shop_url' => $url], ['shop_url']);
        if(isset($data['sAppId']) && ($data['sAppId'] == 24)){
            return ['success' => true];
        }

        if($shopExists['success']){
            if(isset($shopExists['data']['datos']['info'])){

                if($shopExists['data']['datos']['info']['status'] == 'ACCEPTED'){
                    return ['success' => true];
                }
                else if ($shopExists['data']['datos']['info']['status'] == 'UNDER_REVIEW') {
                    return [
                        'success' => false,
                        'force_redirect' => true,
                        'message' => 'Your Facebook Request Status : UNDER_REVIEW. We will notify you once your Application is accepted by Facebook.'
                    ];
                } else {
                    return [
                        'success' => false,
                        'force_redirect' => true,
                        'message' => 'Sorry , your Application is not eligible as per Facebook Guidelines. Kindly contact Facebook support for more details.'
                    ];
                }
            } else {
                return [
                    'success' => false,
                    'force_redirect' => true,
                    'install_form' => 1,
                    'shop_url' => $url
                ];
            }

        } else {
            if(isset($data['bypass_approval']) && $data['bypass_approval']){
                $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(false, false, [
                    'shop_url' => $url,
                    'info' => [
                        'status' => 'ACCEPTED',
                        'email' => isset($data['email']) ? $data['email'] : '',
                        'phone' => isset($data['phone']) ? $data['phone'] : '',
                        'name' => isset($data['name']) ? $data['name'] : '',
                        'category' => isset($data['category']) ? $data['category'] : '',
                        'facebook_id' => isset($data['facebook_id']) ? $data['facebook_id'] : '',
                    ]
                ],
                    ['shop_url']
                );
                return ['success' => true];
            }

            /*$shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(false, false, [
                'shop_url' => $url,
            ],
                ['shop_url']
            );*/

            return [
                'success' => false,
                'force_redirect' => true,
                'install_form' => 1,
                'shop_url' => $url
            ];
        }
    }

    /**
     * @param $baseUrl
     * @param $path
     * @param $params
     * @return string
     */
    public function getUrl($baseUrl,$path,$params){
        $url = parent::getUrl($baseUrl,$path,$params);

        $request_params = $this->di->getRequest()->get();

        $url_parts = parse_url($url);

        // var_dump($url_parts);die;

        $url_params = [];
        if (isset($url_parts['query'])) {
            parse_str($url_parts['query'], $url_params);
        }

        // echo '<pre>';print_r($url_params);die;

        if(!empty($request_params)) {
            $allowed_params = ['host', 'shop'];
            foreach ($request_params as $key=>$value) {
                if(!in_array($key, $allowed_params)){
                    unset($request_params[$key]);
                }
            }

            $request_params = array_merge($url_params, $request_params);
        }

        if(!empty($request_params)) {
            return "{$url_parts['scheme']}://{$url_parts['host']}{$url_parts['path']}?" . http_build_query($request_params);
        } else {
            return $url;
        }
    }
}