<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Product;

use rdx\graphqlquery\Query as phpGraphQueryBuilder;

class QueryQL
{
    /**
     * Modifying query here doesn't reflect on live, kindly note this query output is being cached
     * So plz fluch cache once made changes here
     * @return string
     */
    public function getProductTypeQuery()
    {
        $query = phpGraphQueryBuilder::query('', []);
        $query->fields('shop');
        $query->shop->fields('productTypes');
        $query->shop->productTypes->attribute('first' , 250);
        $query->shop->productTypes->fields('edges');
        $query->shop->productTypes->edges->fields('node');
        return $query->build();
    }

    /**
     * Modifying query here doesn't reflect on live, kindly note this query output is being cached
     * So plz fluch cache once made changes here
     * @return string
     */
    public function getVendorQuery()
    {
        $query = phpGraphQueryBuilder::query('', []);
        $query->fields('shop');
        $query->shop->fields('productVendors');
        $query->shop->productVendors->attribute('first' , 250);
        $query->shop->productVendors->fields('edges');
        $query->shop->productVendors->edges->fields('node');
        return $query->build();
    }

    /**
     * Modifying query here doesn't reflect on live, kindly note this query output is being cached
     * So plz fluch cache once made changes here
     * @return string
     */
    public function getCollectionQuery($type=null)
    {
        $query = phpGraphQueryBuilder::query('', []);
        $query->fields('shop');
        $query->shop->fields('collections');
        $query->shop->collections->attribute('first' , 250);

        if(!is_null($type)) {
            $query->shop->collections->attribute('query' , "collection_type:$type");
        }
        
        $query->shop->collections->fields('edges');
        $query->shop->collections->edges->fields('node');
        $query->shop->collections->edges->node->fields('id', 'title');
        return $query->build();
    }
}