<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Product;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class ProductQL extends Common
{
	public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

	public function getProductAttributes($filter)
	{
		$valid_fields = ['product_type', 'vendor', 'collection'];

		$field = $filter['field'];

		if(in_array($field, $valid_fields))
		{
			switch ($field) {
				case 'product_type':
					/*$query ='query {
	                          	shop {
	                            	productTypes(first:250) {
	                              		edges {
	                                		node
	                              		}
	                            	}
	                          	}
	                    	}';*/
	                $query = $this->di->getCache()->get('shopifyProductTypeQuery', 'shopify');
			        if(!$query){
			            $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Product\QueryQL')->getProductTypeQuery();
			            $this->di->getCache()->set('shopifyProductTypeQuery', $query, 'shopify');
			        }
					break;
				
				case 'vendor':
					/*$query ='query {
	                          	shop {
	                            	productVendors(first:250) {
	                              		edges {
	                                		node
	                              		}
	                            	}
	                          	}
	                    	}';*/
	                $query = $this->di->getCache()->get('shopifyVendorQuery', 'shopify');
			        if(!$query){
			            $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Product\QueryQL')->getVendorQuery();
			            $this->di->getCache()->set('shopifyVendorQuery', $query, 'shopify');
			        }
					break;

				case 'collection':
					/*$query ='query {
	                          	shop {
	                            	collections(first:250) {
	                              		edges {
	                                		node{id, title}
	                              		}
	                            	}
	                          	}
	                    	}';*/
		        	$collectionType = null;
		        	if(isset($filter['collection_type'])) {
		        		switch ($filter['collection_type']) {
		        			case 'custom':
		        				$collectionType = $filter['collection_type'];
		        				break;
		        			
		        			case 'smart':
		        				$collectionType = $filter['collection_type'];
		        				break;
		        		}

		        		if(is_null($collectionType)) {
		        			return [
								'success' 	=> false,
								'msg'		=> '"collection_type" is invalid.'
							];
		        		}
		        	}
		            $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Product\QueryQL')->getCollectionQuery($collectionType);
		            $this->di->getCache()->set('shopifyCollectionTypeQuery', $query, 'shopify');
					break;
			}

			$data = $this->init()->graph($query);
			$res = $this->shapeResponse($data, $field);

			return $res;
		}
		else
		{
			return [
				'success' 	=> false,
				'msg'		=> 'field is invalid.'
			];
		}
	}

	public function shapeResponse($data, $type)
    {
        // todo : check the error logging flag where config value will be checked for error logging rather passing non-relavent message  to frontend
        if (isset($data['errorFlag'])) {
            return $data;
        } elseif (!empty($data['errors'])) {
            $msg = "";
            if (is_array($data['body'])) {
                foreach ($data['body'] as $error) {
                    if (empty($msg)) {
                    	$msg = $error['message'];
                    	continue;
                    }
                    $msg = $msg.' , '. $error['message'];
                }
            } elseif (is_string($data['body'])) {
                return [
                    'success' => false,
                    'message' => $data['body']
                ];
            }
            return [
                'success' => false,
                'message' => $msg
            ];
        }
        // header info
        //print_r($data['response']->getHeaders());die('sd');
        //print_r($data['body']);die('sd');
        switch ($type) {
        	case 'product_type':
        		$shopData = $data['body']['shop'];
        		$return = [
		            'success' => true,
		            'data' => array_column($shopData['productTypes']['edges'], 'node')
		        ];
        		break;
        	
        	case 'vendor':
        		$shopData = $data['body']['shop'];
        		$return = [
		            'success' => true,
		            'data' => array_column($shopData['productVendors']['edges'], 'node')
		        ];
        		break;

        	case 'collection':
        		$shopData = $data['body']['shop'];
        		$return = [
		            'success' => true,
		            'data' => array_column($shopData['collections']['edges'], 'node')
		        ];
        		break;

        	default:
        		$return = [
		            'success' => true,
		            'data' => $data['body']
		        ];
		        break;
        }

        return $return;
    }
}