<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Product;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class Product extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getShopifyProducts($filter = [])
    {
        $this->init(false);
        if(isset($filter['id'])) {

            if($this->_salesChannel) {

                $response = $this->rest('GET', 'product_listings/'.$filter['id'].'.json');

            }
            else {
                $response = $this->rest('GET', 'products/'.$filter['id'].'.json');
            }
        }
        else {
            if(isset($filter['prev']) || isset($filter['next'])) {
                $cursor = base64_decode($filter['prev']??$filter['next']);
                parse_str($cursor, $params);
            }
            else {
                // for saleschannel, limit = default: 50, maximum: 1000
                $default_params = [
                    'limit'     => 250
                ];

                $params = array_merge($default_params, $filter);
            }

            if($this->_salesChannel) {
                $response = $this->rest('GET', 'product_listings.json', $params);
            } else {
                $response = $this->rest('GET', 'products.json', $params);
            }
        }

        $formattedResponse = $this->formatRestResponse($response);

        // Newly added code to return false when no product found
        if(isset($formattedResponse['success']) && $formattedResponse['success']) {
            // data -> product_listings
            // data -> product_listing
            // data -> products
            // data -> products
            if(isset($formattedResponse['data'])) {
                $data = current($formattedResponse['data']);
                if(empty($data)) {
                    $newFormattedResponse = [
                        'success'   => false,
                        'msg'       => 'no product found'
                    ];

                    if(isset($formattedResponse['sales_channel'])) {
                        $newFormattedResponse['sales_channel'] = $formattedResponse['sales_channel'];
                    }

                    if(isset($formattedResponse['cursors'])) {
                        $newFormattedResponse['cursors'] = $formattedResponse['cursors'];
                    }

                    $formattedResponse = $newFormattedResponse;
                }
            }
        }
        // End

        return $formattedResponse;
    }

    public function getProductCount()
    {
        $this->init(false);

        if($this->_salesChannel) {
            $response = $this->rest('GET', 'product_listings/count.json');
        } else {
            $response = $this->rest('GET', 'products/count.json');
        }

        return $this->formatRestResponse($response);
    }

    public function productMetafields($data){
        $productid=$data['id'];
        $data['limit'] = isset($data['limit']) ? $data['limit'] : '100';
        $this->init(false);
        $response = $this->rest('GET', "/products/$productid/metafields.json",$data);

        return $this->formatRestResponse($response);
    }

    public function createShopifyProduct($data)
    {
        $this->init(false);

        $response = $this->rest('POST', 'products.json', $data);

        return $this->formatRestResponse($response); 
    }

    public function updateShopifyProduct($productId, $data)
    {
        $this->init(false);

        $response = $this->rest('PUT', "products/{$productId}.json", $data);

        return $this->formatRestResponse($response); 
    }

    public function getProductWithVariantCount()
    {
        $this->init(false);

        if($this->_salesChannel) {
            $response = $this->rest('GET', 'variants/count.json');
        } else {
            $response = $this->rest('GET', 'variants/count.json');
        }
        return $this->formatRestResponse($response);
    }
}
