<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Order;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class Order extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getShopifyOrders($filter = [])
    {
        $this->init(false);

        if(isset($filter['id'])) {
            $response = $this->rest('GET', 'orders/'.$filter['id'].'.json');
        }
        else {
            if(isset($filter['prev']) || isset($filter['next'])) {
                $cursor = base64_decode($filter['prev']??$filter['next']);
                parse_str($cursor, $params);
            }
            else {
                $default_params = [
                    'limit'     => 250
                ];

                $params = array_merge($default_params, $filter);
            }

            $response = $this->rest('GET', 'orders.json', $params);   
        }

        return $this->formatRestResponse($response);
    }

    public function deleteShopifyOrders($data = []){
        $this->init(false);

        if(isset($data['id'])) {
            $response = $this->rest('DELETE', 'orders/'.$data['id'].'.json');
        }

        return $this->formatRestResponse($response);
    }

    public function createShopifyOrder($data)
    {
        $this->init(false);

        $response = $this->rest('POST', 'orders.json', $data);

        return $this->formatRestResponse($response);
    }


    public function getOrderCount($filter = [])
    {
        $this->init(false);

        $response = $this->rest('GET', 'orders/count.json');

        return $this->formatRestResponse($response);
    }

    public function getordershipment($filter = [])
    {
        $this->init(false);
        
        $response = $this->rest('GET', 'orders/'.$filter['order_id'].'/fulfillments.json');
        return $this->formatRestResponse($response);
        
    }
    public function updateShopifyOrder($orderId, $data)
    {
        $this->init(false);

        $response = $this->rest('PUT', "orders/{$orderId}.json", $data);


        return $this->formatRestResponse($response);
    }

    public function orderCancel($orderId, $data)
    {
        $this->init(false);
        $response = $this->rest('POST', "orders/{$orderId}/cancel.json", $data);
        return $this->formatRestResponse($response);
    }

    public function getFulfillmentOrderData($data)
    {
        $this->init(false);
        $response = $this->rest('GET', 'orders/'.$data['order_id'].'/fulfillment_orders.json');
        return $this->formatRestResponse($response);
    }

    public function fulfillOrderOnShopify($data)
    {
        $this->init(false);

        $response = $this->rest('POST', 'fulfillments.json', $data);

        return $this->formatRestResponse($response);
    }
}