<?php
namespace App\Shopifywebapi\Components\Inventory;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class Processdata extends Common
{
    private $timestamp = 0;     // current timestamp used to compare next time
    private $calls = 0;         // number of calls made since last check
    private $ratelimit = 2;     // 2 api requests per second = 120 per minute
    private $checkfreq = 40;    // allow to burst for 10 seconds before throttling

    /* public function getmicrotime() {
         list($usec, $sec) = explode(" ", microtime());
         return ((float)$usec + (float)$sec);
     }
 */

    public function ratelimit($shop_url) {
        $exists = $this->di->getCache()->exists($shop_url);
        if($exists){
            $this->calls = $this->di->getCache()->get($shop_url);
            $this->calls++;
            $this->di->getCache()->set($shop_url, $this->calls);
        }else{
            $this->calls++;
            $this->di->getCache()->set($shop_url, $this->calls);
        }
        $this->calls = $this->di->getCache()->get($shop_url);
        // check at the preset frequency
        if ($this->calls >= $this->checkfreq) {
            sleep(2);
            $this->calls=0;
            $this->di->getCache()->deleteKey($shop_url);
        }
        $res['calls']=$this->calls;
        $res['timest']=$this->timestamp;
        return $res;
    }
}
?>