<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Inventory;

use Exception;
use App\Shopifywebapi\Components\Core\Common;

class Inventory extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getInventoryLevels($filter = [])
    {
        $this->init(false);

        if(isset($filter['prev']) || isset($filter['next'])) {
            $cursor = base64_decode($filter['prev']??$filter['next']);
            parse_str($cursor, $params);
        }else {
            $default_params = [
                'limit'     => 250
            ];

            $params = array_merge($default_params, $filter);
        }
        $shop_url=$this->_shop;
        if($shop_url=="puspanjalitest.myshopify.com"){
//            $rateres= $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Inventory\Ratelimit')->ratelimit($shop_url);
            $response = $this->rest('GET', 'inventory_levels.json', $params);
            $call_limit=$response->call_limit;
            $rateres="";
        }else{
            $response = $this->rest('GET', 'inventory_levels.json', $params);
            $rateres="";
            $call_limit="";
        }
        $res=$this->formatRestResponse($response);
        $res['shop_url']=$shop_url;
        $res['ratelimit']=$rateres;
        $res['call_limit']=$call_limit;
        return $res;
    }

    public function setInventoryLevels($params)
    {
        $this->init(false);

        $response = $this->rest('POST', 'inventory_levels/set.json', $params);

        return $this->formatRestResponse($response);

    }

    public function connectInventoryLevels($params)
    {
        $this->init(false);

        $response = $this->rest('POST', 'inventory_levels/connect.json', $params);

        return $this->formatRestResponse($response);

    }
}