<?php
/**
 * CedCommerce
 **/
namespace App\Shopifywebapi\Components;

class Helper extends \App\Core\Components\Base
{
    /**
     * Get Particular app from apps_shop using shopID and appCode
     */
    public function getAppShopUsingAppCode($shopId, $appCode)
    {
        $appShopCollection = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo')->getCollectionForTable('apps_shop');
        
        $query = [
            [
                '$match' => [
                    '_id' => $shopId   //Stage 1 - Get app using remote shop Id
                ]
            ],
            [
                '$unwind' => '$apps'  //Stage 2 - Unwind apps column from the document
            ],
            [
                '$match' => [
                    'apps.app_code' => $appCode  //Stage 3 - Match the apps column appCode with config appCode
                ]
            ]
        ];
        $response = $appShopCollection->aggregate($query)->toArray();
        return $response;
    }

    public function getIdInfo($id)
    {
        if(($pos = strpos($id, '?')) !== false) {
            $id = substr($id, 0, $pos);
        }

        $id = str_replace('gid://shopify/', '', $id);

        $id_info = explode('/', $id);

        return [
            'type'	=> $id_info[0],
            'id' 	=> $id_info[1],
            'path'	=> $id
        ];
    }

    public function validateHmac($params)
    {
        try {
            $appConfig = $this->di->getRegistry()->getAppConfig();

            if($appConfig['marketplace'] === 'shopify')
            {
                if(array_key_exists('shop', $params) && array_key_exists('hmac', $params) && array_key_exists('timestamp', $params))
                {
                    $authCommon = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Authenticate\Common');
                    
                    $authCommon->setSellerCredentials('');
                    
                    $resp = $authCommon->verifyRequest($params);

                    if($resp) {
                        return [
                            'success' => true,
                            'data' => '',
                            'msg' => 'hmac validation successful.'
                        ];
                    } else {
                        return [
                            'success' => false,
                            'msg' => 'hmac validation failed.'
                        ];
                    }
                }
                else
                {
                    return [
                        'success' => false,
                        'msg' => 'shop, hmac & timestamp are required.'
                    ];
                }
            }
            else
            {
                return [
                    'success' => false,
                    'msg' => 'hmac validation works for shopify marketplace only.'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}