<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Fulfillment;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class Fulfillment extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function createfulfillmentServices($query, array $variables = [])
    {
        $this->init(false);
        
        $response = $this->rest('POST', "/fulfillment_services.json",$query);
        return $this->formatRestResponse($response);
    } 

    public function cancelfulfillmentServices($query,$fulfillment_id){
        $this->init(false);

        $response = $this->rest('POST','/fulfillment'.'/'.$fulfillment_id.'/cancel.json',$query);
        return $this->formatRestResponse($response);
    }

    public function rejectFulfillment($fulfillment_order_id, $data){
        $this->init(false);
        $response = $this->rest('POST','/fulfillment_orders'.'/'.$fulfillment_order_id.'/fulfillment_request/reject.json',$data);
        return $this->formatRestResponse($response);
        
    }

    public function acceptingfulfillmentrequest($query,$fulfillment_order_id){
        $this->init(false);

        $response = $this->rest('POST','/'.$fulfillment_order_id.'/fulfillment/accept.json',$query);
        return $this->formatRestResponse($response);

    }

    public function acceptcancellationrequest($query,$fulfillment_order_id){
        $this->init(false);
        $body = ["cancellation_request" => ["message" => "We had not started any processing yet."]];
        $response = $this->rest('POST','/fulfillment_orders'.'/'.$fulfillment_order_id.'/cancellation_request/accept.json',$body);
        return $this->formatRestResponse($response);
    }

    public function rejectcancellationrequest($query,$fulfillment_order_id){
        $this->init(false);
        $response = $this->rest('POST','/fulfillment_orders'.'/'.$fulfillment_order_id.'/cancellation_request/reject.json');
        return $this->formatRestResponse($response);
        
    }

    public function closefulfillmentorder($query,$fulfillment_order_id){
        $this->init(false);
        $response = $this->rest('POST','/fulfillment_orders'.'/'.$fulfillment_order_id.'/close.json',$query);
        return $this->formatRestResponse($response);
    }

    public function assignedfulfillments($data){
        $this->init(false);
        $response = $this->rest('GET','/assigned_fulfillment_orders.json', $data);
        return $this->formatRestResponse($response);
    }

    public function acceptfulfillmentorder($fulfillment_order_id){
        $this->init(false);
        $response = $this->rest('POST','/fulfillment_orders'.'/'.$fulfillment_order_id.'/fulfillment_request/accept.json');
        return $this->formatRestResponse($response);
    }

    public function cancellfulfillmentorder($fulfillment_order_id){
        $this->init(false);
        $response = $this->rest('POST','/fulfillment_orders'.'/'.$fulfillment_order_id.'/cancellation_request.json');
        return $this->formatRestResponse($response);
    }

    public function getOrderFulfillmentOrder($order_id){
        $this->init(false);
        $response = $this->rest('GET','/orders'.'/'.$order_id.'.json');
        return $this->formatRestResponse($response);

    }

    public function deleteFulfillmentServices($fulfillment_id){
        $this->init(false);

        $response = $this->rest('DELETE','fulfillment_services'.'/'.$fulfillment_id.'.json');
        return $this->formatRestResponse($response);

    }

    public function updateTrackingDetails($fulfillment_id,$body){
        $this->init(false);

        $response = $this->rest('POST','/fulfillments'.'/'.$fulfillment_id.'/update_tracking.json',$body);
        return $this->formatRestResponse($response);

    }

    public function getFulfillmentServices($id)
    {
        $this->init(false);

        $response = $this->rest('GET','/fulfillment_services'.'/'.$id.'.json');
        return $this->formatRestResponse($response);
    }

    public function createFulfillments($body){
        $this->init(false);
        
        $response = $this->rest('POST','/fulfillments.json',$body);
        return $this->formatRestResponse($response);     
    }

    public function fulfillmentOrdersCancel($data)
    {
        $this->init(false);

        $response = $this->rest('POST','fulfillments/'.$data['fulfillment_order_id'].'/cancel.json');
        return $this->formatRestResponse($response);
    }

}