<?php

namespace App\Shopifywebapi\Components\Files;

use App\Shopifywebapi\Components\Core\Common;

class FilesQL extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getFileUrlUsingId($data)
    {
        if (!isset($data['id'])) {
            return [
                'success' => false,
                'message' => 'missing parameter id'
            ];
        }
        $this->init(false);

        $query = 'query {
            files(first: 1, query: "id:'.$data['id'].'") {
              edges {
                node {
                  fileStatus
                  ... on MediaImage {
                    image {
                      url
                    }
                  }
                }
              }
            }
          }
        ';

        $response = $this->init()->graph($query);
        if (isset($response['body']['files']['edges'])) {
            $response['body'] = array_column($response['body']['files']['edges'], 'node');
        }
        return $this->shapeResponse($response);
    }

    public function commenceStagedUploadsCreate($data)
    {
        $this->init(false);
        if (!isset($data['filename'], $data['httpMethod'], $data['mimeType'], $data['resource'])) {
            return [
                'success' => false,
                'message' => 'missing parameters'
            ];
        }

        $query = '
            mutation stagedUploadsCreate($input: [StagedUploadInput!]!) {
                stagedUploadsCreate(input: $input) {
                    stagedTargets {
                        url
                        resourceUrl
                        parameters {
                            name
                            value
                        }
                    }
                    userErrors {
                        field
                        message
                    }
                }
            }
            ';
        $variables = [
            'input' => [
                'filename' => $data['filename'],
                'httpMethod' => $data['httpMethod'],
                'mimeType' => $data['mimeType'],
                'resource' => $data['resource'],
            ]
        ];

        $response = $this->init()->graph($query, $variables);
        return $this->shapeResponse($response);
    }

    public function createFileOnShopify($data)
    {
        $this->init(false);
        if (!isset($data['alt'], $data['contentType'], $data['url'])) {
            return [
                'success' => false,
                'message' => 'missing required parameters'
            ];
        }

        $query = '
        mutation fileCreate($files: [FileCreateInput!]!) {
             fileCreate(files: $files) {
                 files {
                     alt
                     createdAt
                     ... on GenericFile {
                        id
                      }
                      ... on MediaImage {
                        id
                      }
                      ... on Video {
                        id
                      }
                    }
                }
            }';
        $variables = [
            'files' => [
                'alt' => $data['alt'],
                'contentType' => $data['contentType'],
                'originalSource' => $data['url'],
            ]
        ];

        $response = $this->init()->graph($query, $variables);
        return $this->shapeResponse($response);
    }

    public function shapeResponse($apiResponse)
    {
        if (!empty($apiResponse['errors'])) {
            $msg = is_array($apiResponse['body'])
                ? implode(' , ', array_column($apiResponse['body'], 'message'))
                : $apiResponse['body'];
            if (empty($msg)) {
                $msg = $apiResponse['body'];
            }
            return ['success' => false, 'message' => $msg];
        }
        return ['success' => true, 'data' => $apiResponse['body']];
    }
}
