<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Customer;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class Customer extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getCustomerCount($filter = [])
    {
        $this->init(false);
        $response = $this->rest('GET', 'customers/count.json');
        return $this->formatRestResponse($response);
    }

    public function getShopifyCustomers($filter = [])
    {
        $this->init(false);

        if(isset($filter['id'])) {
            $response = $this->rest('GET', 'customers/'.$filter['id'].'.json');
        }
        else {
            if(isset($filter['prev']) || isset($filter['next'])) {
                $cursor = base64_decode($filter['prev']??$filter['next']);
                parse_str($cursor, $params);
            }
            else {
                $default_params = [
                    'limit'     => 250
                ];

                $params = array_merge($default_params, $filter);
            }

            $response = $this->rest('GET', 'customers.json', $params);
        }

        return $this->formatRestResponse($response);
    }

    public function getCustomerAddress($filter = []){
        $this->init(false);
        
        $response = $this->rest('GET', 'customers/'.$filter['customer_id'].'/orders.json'); //addresses
        return $this->formatRestResponse($response);
    }

    public function getAllOrdersPlacedByCustomer($filter = []){
        $this->init(false);
        
        $response = $this->rest('GET', 'customers/'.$filter['customer_id'].'/orders.json');
        return $this->formatRestResponse($response);
    }
}