<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Collection;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

use rdx\graphqlquery\Query as phpGraphQueryBuilder;


class Collection extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getCollections($filter = [])
    {
        $this->init(false);

        $collection_type = '';

        switch ($filter['collection_type']) {
            case 'smart':
                $collection_type = 'smart';
                break;
            
            case 'custom':
                $collection_type = 'custom';
                break;
        }

        if(!empty($collection_type))
        {
            if(isset($filter['id'])) {
                $response = $this->rest('GET', "{$collection_type}_collections/{$filter['id']}.json");
            }
            else {
                if(isset($filter['prev']) || isset($filter['next'])) {
                    $cursor = base64_decode($filter['prev']??$filter['next']);
                    parse_str($cursor, $params);
                }
                else {
                    $default_params = [
                        'limit'     => 250
                    ];

                    $params = array_merge($default_params, $filter);
                }

                $response = $this->rest('GET', "{$collection_type}_collections.json", $params);   
            }

            return $this->formatRestResponse($response);
        }
        else 
        {
            return [
                'success'   => false,
                'msg'       => 'collection_type is invalid'
            ];
        }
    }

    public function getCollectionCount()
    {
        $this->init(false);

        $response = $this->rest('GET', 'smart_collections/count.json');

        return $this->formatRestResponse($response);
    }


    public function getAllCollectionsUsingProductId($productId)
    {
        $this->init(false);
        $query = phpGraphQueryBuilder::query('', []);
        $query->fields('product');
        $query->product->attribute('id', "gid://shopify/Product/".$productId);
        $query->product->fields('collections');
        $query->product->collections->attribute("first", 95);
        $query->product->collections->fields("nodes");
        $query->product->collections->nodes->fields('id');
        $query->product->collections->nodes->fields('title');
        $builtQuery = $query->build();
        return $this->graph($builtQuery);

        // query{
        //     product(id: "gid://shopify/Product/8065429111061") {
        //       collections(first:95) {
        //         nodes {
        //           id
        //         }
        //       }
        //     }
        //   }
    }
}
