<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\BulkOperation;

use rdx\graphqlquery\Query as phpGraphQueryBuilder;

class QueryQL
{
    public function getBulkOperationCreateMutation($query)
    {

        $mutation = phpGraphQueryBuilder::mutation('', []);
        $mutation->field('bulkOperationRunQuery');
        $mutation->bulkOperationRunQuery->attribute('query' , phpGraphQueryBuilder::enum($query));
        $mutation->bulkOperationRunQuery->field('bulkOperation');
        $mutation->bulkOperationRunQuery->bulkOperation->field('id');
        $mutation->bulkOperationRunQuery->bulkOperation->field('status');
        $mutation->bulkOperationRunQuery->field('userErrors');
        $mutation->bulkOperationRunQuery->userErrors->field('field');
        $mutation->bulkOperationRunQuery->userErrors->field('message');

        return $mutation->build();
    }

    public function getCurrentBulkOperationQuery()
    {

        $query = phpGraphQueryBuilder::query('', []);
        $query->fields('currentBulkOperation');
        $query->currentBulkOperation->fields('id status errorCode createdAt completedAt objectCount fileSize url partialDataUrl');
        return $query->build();
    }

    public function getBulkOperationQuery($id)
    {

        $query = <<<QUERY
query {
    node(id: "$id") {
        ... on BulkOperation {
            id
            status
            errorCode
            createdAt
            completedAt
            objectCount
            fileSize
            url
            partialDataUrl
        }
    }
}
QUERY;

        return $query;
    }

    public function getBulkOperationCancelMutation($id)
    {

        $mutation = phpGraphQueryBuilder::mutation('', []);
        $mutation->field('bulkOperationCancel');
        $mutation->bulkOperationCancel->attribute('id', $id);
        $mutation->bulkOperationCancel->field('bulkOperation');
        $mutation->bulkOperationCancel->bulkOperation->field('id');
        $mutation->bulkOperationCancel->field('userErrors');
        $mutation->bulkOperationCancel->userErrors->field('field');
        $mutation->bulkOperationCancel->userErrors->field('message');

        return $mutation->build();
    }
}