<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\BulkOperation\Parser;

use App\Shopifywebapi\Components\BulkOperation\Parser\ReadFile;

class JSONLParser extends ReadFile
{
	const DELIMETER = '~';

	public function getItemCount()
	{
		$counts = [];

		$jsonl_formatter = new JSONLFormatter();

		$next_seek = 0;
		while ($next_seek < $this->getFileSize())
		{
			$json_lines_data = $this->getJsonLines(['seek' => $next_seek]);

			$json = $json_lines_data['data'];
			$items = json_decode($json, true);
						
			foreach ($items as $key => $item)
			{
				if(isset($item['id']))
				{
					$id_info = $jsonl_formatter->getIdInfo($item['id']);

					if(isset($counts[$id_info['type']])) {
						$counts[$id_info['type']]++;
					} else {
						$counts[$id_info['type']] = 1;
					}
				}
			}

			$next_seek = $json_lines_data['seek'];
		}

		return [
			'success'	=> true,
			'data'		=> $counts
		];
	}

	public function getItems($params)
	{
		$limit = isset($params['limit']) ? intval($params['limit']) : 250;
		$next_seek = 0;
		$skip_till_key = -1;

		if(isset($params['next']))
		{
			$validate = $this->validateNext($params['next']);
			if($validate['status'])
			{
				$explod = explode(self::DELIMETER, $validate['data']);
				array_walk($explod, function (&$item) {$item = intval($item);});
				list($limit, $next_seek, $skip_till_key) = $explod;
			}
			else
			{
				return [
					'success'	=> false,
					'msg'       => 'Next Cursor is Invalid'
				];
			}
		}

		$count = 0;
		$current_seek = $next_seek;

		$flag_breaked = false;

		$jsonl_formatter = new JSONLFormatter();
		
		while ($next_seek < $this->getFileSize())
		{
			$json_lines_data = $this->getJsonLines(['seek' => $next_seek]);

			$json = $json_lines_data['data'];
			$items = json_decode($json, true);
						
			foreach ($items as $key => $item)
			{
				if($skip_till_key > $key) {
					continue;
				}

				if(isset($item['__parentId']))
				{
					$jsonl_formatter->setItem($item);
				}
				else
				{
					if($count === $limit) {
						$flag_breaked = true;
						break;
					}
					else {
						$jsonl_formatter->setItem($item);

						$count++;
					}
				}
			}

			$next_seek = $json_lines_data['seek'];
			
			if(!$flag_breaked) {
				$current_seek = $json_lines_data['seek'];
				$skip_till_key = -1;
			}
			else {
				$skip_till_key = $key;
				break;
			}
		}
		
		$response = [
			'success'	=> true,
			'data'		=> $jsonl_formatter->getFormattedData()
		];

		if(!$flag_breaked) {
			if($next_seek !== 0 && $next_seek !== $this->getFileSize()) {
				$response['cursors']['next'] = urlencode(base64_encode($limit . self::DELIMETER . $next_seek . self::DELIMETER . '-1'));
			}
		}
		else {
			$response['cursors']['next'] = urlencode(base64_encode($limit . self::DELIMETER . $current_seek . self::DELIMETER . $skip_till_key));
		}

		// if(isset($params['next'])) {
		// 	$response['cursors']['prev'] = urlencode($params['next']);
		// }

		return $response;
	}

	private function validateNext($next)
	{
		$next = urldecode($next);
		$next = base64_decode($next, true);

		if($next) {
			if(substr_count($next, self::DELIMETER) === 2) {
				return [
					'status'=> true,
					'data'	=> $next
				];
			}
		}
		
		return ['status' => false];
	}
}