<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\BulkOperation;

class BulkOperationQuery
{
    public function getBulkOperationQuery($data)
    {
        if ($data['type'] === 'query') {
            if (isset($data['query'])) {
                $query = $data['query'];
                return [
                    'success' => true,
                    'query' => <<<QUERY
"""
$query
"""
QUERY
                ];
            } else {
                return [
                    'success' => false,
                    'msg' => 'must pass graphlq query in "query" index when "type" is "query".'
                ];
            }
        } else {
            return $this->getQueryByType($data['type'], $data);
        }
    }

    private function getQueryByType($type, $data)
    {
        $method_name = 'getQueryFor' . ucfirst(strtolower($type));

        if (method_exists($this, $method_name)) {
            return [
                'success' => true,
                'query' => $this->$method_name($data)
            ];
        } else {
            return [
                'success' => false,
                'msg' => 'Invalid Bulk Operation type',
            ];
        }
    }

    /**
     * @return string
     */
    private function getQueryForInventory($data)
    {
        $query = <<<QUERY
"""
{
    inventoryItems(first: 10) {
        edges {
            node {
                id
                variant {
                    id
                }
                inventoryLevels(first: 10) {
                    edges {
                        node {
                            available
                            location {
                                id
                            }
                        }
                    }
                }
            }
        }
    }
}
"""
QUERY;

        return $query;
    }

    private function getQueryForProductMetafields($data)
    {
        $query = <<<QUERY
"""
{
      products {
        edges {
          node {
            id
            metafields {
              edges {
                node {
                  id
                  namespace
                  key
                  value,
                  valueType,
                  description,
                  ownerType
                }
              }
            }
          }
        }
      }
}
"""
QUERY;

        return $query;
    }

    /**
     * @return string
     */
    private function getQueryForProduct($data)
    {

        $query = <<<QUERY
"""
{
    products(first:1, query:"NOT (status:draft)") {
        edges {
            node {
                id
                title
                vendor
                productType
                description
                descriptionHtml
                handle
                tags
                templateSuffix
                seo {
                    title
                    description
                }
                featuredImage {
                    id
                    originalSrc
                    transformedSrc
                }
                images (first:10) {
                    edges {
                        node {
                            id
                            originalSrc
                            transformedSrc
                        }
                    }
                }
                collections (first:1) {
                    edges {
                        node {
                            id
                            title
                        }
                    }
                }
                publishedAt
                createdAt
                updatedAt
                variants(first:1) {
                    edges {
                        node {
                            id
                            title
                            position
                            sku
                            price
                            compareAtPrice
                            inventoryQuantity
                            weight
                            weightUnit
                            barcode
                            inventoryPolicy
                            taxable
                            createdAt
                            updatedAt
                            fulfillmentService {
                                handle
                                serviceName
                            }
                            image {
                                id
                                originalSrc
                                transformedSrc
                            }
                            selectedOptions {
                                name
                                value
                            }
                            inventoryItem {
                                id
                                tracked
                                requiresShipping
                                inventoryLevels(first:8) {
                                    edges {
                                        node {
                                            id
                                            quantities(names: ["available"]) {
                                                name
                                                quantity
                                            }
                                            updatedAt
                                            location {
                                                id
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
"""
QUERY;

        return $query;
    }

    /**
     * @return string
     */
    private function getQueryForSaleschannelproduct($data)
    {
        $query = <<<QUERY
"""
{
  appInstallation {
    publication {
      products(first: 1) {
        edges {
            node {
                id
                title
                vendor
                productType
                description
                descriptionHtml
                handle
                tags
                seo {
                  description
                  title
                }
                templateSuffix
                featuredImage {
                    id
                    originalSrc
                    transformedSrc
                }
                seo {
                    title
                    description
                }
                images (first:10) {
                    edges {
                        node {
                            id
                            originalSrc
                            transformedSrc
                        }
                    }
                }
                collections (first:1) {
                    edges {
                        node {
                            id
                            title
                        }
                    }
                }
                publishedAt
                createdAt
                updatedAt
                variants(first:1) {
                    edges {
                        node {
                            id
                            title
                            position
                            sku
                            price
                            compareAtPrice
                            inventoryQuantity
                            weight
                            weightUnit
                            barcode
                            inventoryPolicy
                            taxable
                            createdAt
                            updatedAt
                            fulfillmentService {
                                handle
                                serviceName
                            }
                            image {
                                id
                                originalSrc
                                transformedSrc
                            }
                            selectedOptions {
                                name
                                value
                            }
                            inventoryItem {
                                id
                                tracked
                                requiresShipping
                                inventoryLevels(first:8) {
                                    edges {
                                        node {
                                            id
                                            available
                                            updatedAt
                                            location {
                                                id
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
      }
    }
  }
}
"""
QUERY;

        return $query;
    }

    private function getQueryForMetafield($data)
    {
        $query = <<<QUERY
"""
{
    products(first:1, query:"NOT (status:draft)") {
        edges {
            node {
                id
                metafields {
                    edges {
                      node {
                        id
                        namespace
                        key
                        value
                      }
                    }
                }
                variants(first:1) {
                    edges {
                        node {
                            id
                            sku
                            selectedOptions {
                                name
                                value
                            }
                            metafields {
                                edges {
                                  node {
                                    id
                                    namespace
                                    key
                                    value
                                  }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
"""
QUERY;

        return $query;
    }

    private function getQueryForProductForMcf($data)
    {
        $query = <<<QUERY
"""
{
    products(first:1, query:"NOT (status:draft)") {
        edges {
            node {
                id
                title
                featuredImage {
                    id
                    originalSrc
                    transformedSrc
                }
                publishedAt
                createdAt
                updatedAt
                variants(first:1) {
                    edges {
                        node {
                            id
                            title
                            sku
                            barcode
                            inventoryPolicy
                            createdAt
                            updatedAt
                            fulfillmentService {
                                handle
                                serviceName
                            }
                            image {
                                id
                                originalSrc
                                transformedSrc
                            }
                            selectedOptions {
                                name
                                value
                            }
                            inventoryItem {
                                id
                                tracked
                                requiresShipping
                                inventoryLevels(first:8) {
                                    edges {
                                        node {
                                            id
                                            available
                                            updatedAt
                                            location {
                                                id
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
"""
QUERY;

        return $query;
    }

    private function getQueryForBulkinventory($data)
    {
        $query = <<<QUERY
"""
{
    products(first:1, query:"NOT (status:draft)") {
        edges {
            node {
                id
                variants(first:1) {
                    edges {
                        node {
                            id
                            sku
                            inventoryQuantity
                            selectedOptions {
                                name
                                value
                            }
                            inventoryItem {
                                id
                                tracked
                                requiresShipping
                                inventoryLevels(first:8) {
                                    edges {
                                        node {
                                            id
                                            available
                                            updatedAt
                                            location {
                                                id
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
"""
QUERY;

        return $query;
    }
}